% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/graph_metrics.R
\name{keyplayer}
\alias{keyplayer}
\title{Compute a KPP-Pos set for a given graph.}
\usage{
keyplayer(g, k, prob = 0, tol = 1e-04, maxsec = 120, roundsec = 30)
}
\arguments{
\item{g}{The igraph object to analyze.}

\item{k}{The size of the KP-set}

\item{prob}{probability of accepting a state with a lower value}

\item{tol}{tolerance within which to stop the optimization and accept the current value}

\item{maxsec}{The total computation budget for the optimization, in seconds}

\item{roundsec}{Number of seconds in between synchronizing workers' answer}
}
\value{
a vector with the vertex number of each vertex in the selected set S.
}
\description{
The "Key Player" family of node importance algorithms (Borgatti 2006) involves the selection
of a metric of node importance and a combinatorial optimization strategy to
choose the set S of vertices of size k that maximize that metric.
}
\details{
This function implements KPP-Pos, a metric intended to identify k nodes which
optimize resource diffusion through the network. We sum over all vertices
not in S the reciprocal of the shortest distance to a vertex in S.

According to Borgatti, a number of off-the-shelf optimization algorithms may
be suitable to find S, such as tabu-search, K-L, simulated annealing, or
genetic algorithms. He presents a simple greedy algorithm, which we excerpt
here:

 \enumerate{
   \item Select k nodes at random to populate set S
   \item Set F = fit using appropriate key player metric.
   \item For each node u in S and each node v not in S:
     \itemize{\item DELTAF = improvement in fit if u and v were swapped}
   \item Select pair with largest DELTAF
     \itemize{
       \item If DELTAF <= [tolerance] then terminate
       \item Else, swap pair with greatest improvement in fit and set F = F + DELTAF
     }
   \item Go to step 3.
}

Our implementation uses a different optimization method which we call
stochastic gradient descent. In tests on real world data, we found that
our method discovered sets S with larger fits in less computation time.
The algorithm is as follows:

\enumerate{
 \item Select k nodes at random to populate set S
 \item Set F = fit using appropriate key player metric (KPP-Pos in our case)
 \item Get a new state:
 \itemize{
   \item Pick a random u in S and v not in S.
   \item F' = fit if u and v were swapped
   \item If F' > F, swap u and v in S. Else, repeat step 3. (Alternatively, if a positive value is given for the `prob' parameter, a swap will be accepted with a small probability regardless of whether it improves the fit).
 }
 \item If F' - F < tolerance or our maximum computation time is exceeded, return S. Else, go to step 3.
}

This implementation uses OpenMP (if available on the host system) so that
multiple workers can explore the solution space in parallel. After a given
of time, the workers synchronize their sets S to the one which maximizes
the metric.
}
\examples{
ig.ex <- igraph::erdos.renyi.game(100, p.or.m=0.3) # generate an undirected 'igraph' object
keyplayer(ig.ex, k=10) # key-player set consisting of 10 actors
}
\references{
\url{https://www.bebr.ufl.edu/sites/default/files/Borgatti\%20-\%202006\%20-\%20Identifying\%20sets\%20of\%20key\%20players\%20in\%20a\%20social\%20networ.pdf}
}

