% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ind-ttest.R
\name{ind_ttest}
\alias{ind_ttest}
\title{Two Independent Sample t Test}
\usage{
ind_ttest(data, x, y, confint = 0.95, alternative = c("both", "less",
  "greater", "all"), ...)
}
\arguments{
\item{data}{a data frame}

\item{x}{grouping variable; object of type \code{factor}}

\item{y}{a \code{numeric} vector}

\item{confint}{confidence level}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of "both" (default), "greater", "less" or "all". You can specify
just the initial letter}

\item{...}{additional arguments passed to or from other methods}
}
\value{
\code{ind_ttest} returns an object of class \code{"ind_ttest"}.
An object of class \code{"ind_ttest"} is a list containing the
following components:

\item{levels}{levels of \code{x}}
\item{obs}{number of observations of \code{y} for each level of \code{x}}
\item{n}{total number of observations}
\item{mean}{mean of \code{y} for each level of \code{x}}
\item{sd}{standard deviation of \code{y} for each level of \code{x}}
\item{se}{estimate of standard error of \code{y} for each level of \code{x}}
\item{lower}{lower limit for the mean of \code{y} for each level of \code{x}}
\item{upper}{upper limit for the mean of \code{y} for each level of \code{x}}
\item{combined}{a data frame; mean, standard deviation, standard error and
confidence limit of mean of \code{y}}
\item{mean_diff}{difference in mean of \code{y} for the two groups of \code{x}}
\item{se_dif}{estimate of the standard error for difference in mean of
\code{y} for the two groups of \code{x}} \item{sd_dif}{degrees of freedom}
\item{conf_diff}{confidence interval for \code{mean_diff}}
\item{df_pooled}{degrees of freedom for the pooled method}
\item{df_satterthwaite}{degrees of freedom for the Satterthwaite method}
\item{t_pooled}{t statistic for the pooled method}
\item{t_satterthwaite}{t statistic for the Satterthwaite method}
\item{sig_pooled}{two-sided p-value for the pooled method}
\item{sig_pooled_l}{lower one-sided p-value for the pooled method}
\item{sig_pooled_u}{upper one-sided p-value for the pooled method}
\item{sig}{two-sided p-value for the Satterthwaite method}
\item{sig_l}{lower one-sided p-value for the Satterthwaite method}
\item{sig_u}{upper one-sided p-value for the Satterthwaite method}
\item{num_df}{numerator degrees of freedom for folded f test}
\item{den_df}{denominator degrees of freedom for folded f test}
\item{f}{f value for the equality of variances test}
\item{f_sig}{p-value for the folded f test}
\item{var_y}{name of \code{y}}
\item{confint}{confidence level}
\item{alternative}{alternative hypothesis}
}
\description{
\code{ind_ttest} compares the means of two independent groups in order to determine whether 
there is statistical evidence that the associated population means are significantly different.
}
\examples{
# lower tail
ind_ttest(hsb, 'female', 'write', alternative = 'less')

# upper tail
ind_ttest(hsb, 'female', 'write', alternative = 'greater')

# both tails
ind_ttest(hsb, 'female', 'write', alternative = 'both')

# all tails
ind_ttest(hsb, 'female', 'write', alternative = 'all')
}
\references{
Sheskin, D. J. 2007. Handbook of Parametric and Nonparametric
Statistical Procedures, 4th edition. : Chapman & Hall/CRC.
}
\seealso{
\code{\link[stats]{t.test}}
}

