% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_p_value.R
\name{get_p_value}
\alias{get_p_value}
\alias{get_pvalue}
\title{Compute p-value}
\usage{
get_p_value(x, obs_stat, direction)

get_pvalue(x, obs_stat, direction)
}
\arguments{
\item{x}{Data frame of calculated statistics as returned by \code{\link[=generate]{generate()}}}

\item{obs_stat}{A numeric value or a 1x1 data frame (as extreme or more
extreme than this).}

\item{direction}{A character string. Options are \code{"less"}, \code{"greater"}, or
\code{"two_sided"}. Can also use \code{"left"}, \code{"right"}, or \code{"both"}.}
}
\value{
A 1x1 \link[tibble:tibble]{tibble} with value between 0 and 1.
}
\description{
Simulation-based methods are (currently only) supported.
}
\section{Aliases}{

\code{get_pvalue()} is an alias of \code{get_p_value()}.
\code{p_value} is a deprecated alias of \code{get_p_value()}.
}

\examples{
# Prepare the dataset
mtcars_df <- mtcars \%>\%
  dplyr::mutate(am = factor(am))

# Calculate the difference in means in the dataset
d_hat <- mtcars_df \%>\%
  specify(mpg ~ am) \%>\%
  calculate(stat = "diff in means", order = c("1", "0"))

# Same calculation on 100 permutation replicates
null_distn <- mtcars_df \%>\%
  specify(mpg ~ am) \%>\%
  hypothesize(null = "independence") \%>\%
  generate(reps = 100) \%>\%
  calculate(stat = "diff in means", order = c("1", "0"))

# What proportion of replicates had a difference
# in means more extreme than in the dataset?
null_distn \%>\%
  get_p_value(obs_stat = d_hat, direction = "right")
}
