% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/FuncionesAuxiliares_denue.R
\name{denue_varios_stats}
\alias{denue_varios_stats}
\title{Obtiene estadisticas de coordenada}
\usage{
denue_varios_stats(data, col_lat, col_long, token, metros = 250,
  keyword = "todos")
}
\arguments{
\item{data}{Data.frame dónde se encuentran las dos columnas de coordenadas}

\item{col_lat}{número de columna de "data" en dónde se encuenta la latitud}

\item{col_long}{número de columna de "data" en dónde se encuenta la longitud}

\item{token}{Token emitida por INEGI para acceder a API}

\item{metros}{Distancia en metros a la redonda para buscar establecimientos. Default = 250}

\item{keyword}{Palabra clave de establecimiento para buscar. Por default busca todos.}
}
\value{
Data.frame
}
\description{
Regresa Data.Frame con estadísticas básicas sobre los establecimientos encontrados a la rendonda de coordenada, utilizando denue_inegi().
Trae una función de loop integrada, para que pueda regresar indicadores de muchas coordenadas, utilizando un data.frame.
}
\examples{
#indicadores de 2 lugares
\dontrun{
token<-"webservice_token"
df<-as.data.frame(latitud  = c(25.669194,25.121194),
                  longitud = c(-100.30990,-99.81923))
stats<-denue_varios_stats(data     = df,
                          col_lat  = 1,
                          col_long = 2,
                          metros   = 500)
}
}
\author{
Eduardo Flores
}

