% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/double_variable.R
\name{DoubleVariable}
\alias{DoubleVariable}
\title{DoubleVariable Class}
\description{
Represents a continuous variable for an individual.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{DoubleVariable$new()}}
\item \href{#method-get_values}{\code{DoubleVariable$get_values()}}
\item \href{#method-get_index_of}{\code{DoubleVariable$get_index_of()}}
\item \href{#method-get_size_of}{\code{DoubleVariable$get_size_of()}}
\item \href{#method-queue_update}{\code{DoubleVariable$queue_update()}}
\item \href{#method-.update}{\code{DoubleVariable$.update()}}
\item \href{#method-clone}{\code{DoubleVariable$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new DoubleVariable
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DoubleVariable$new(initial_values)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{initial_values}}{a numeric vector of the initial value for each
individual}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_values"></a>}}
\if{latex}{\out{\hypertarget{method-get_values}{}}}
\subsection{Method \code{get_values()}}{
get the variable values
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DoubleVariable$get_values(index = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{optionally return a subset of the variable vector. If
\code{NULL}, return all values; if passed a \code{\link[individual]{Bitset}}
or integer vector, return values of those individuals.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_index_of"></a>}}
\if{latex}{\out{\hypertarget{method-get_index_of}{}}}
\subsection{Method \code{get_index_of()}}{
return a \code{\link[individual]{Bitset}} giving individuals 
whose value lies in an interval \eqn{[a,b]}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DoubleVariable$get_index_of(a, b)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{a}}{lower bound}

\item{\code{b}}{upper bound}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_size_of"></a>}}
\if{latex}{\out{\hypertarget{method-get_size_of}{}}}
\subsection{Method \code{get_size_of()}}{
return the number of individuals whose value lies in an interval
Count individuals whose value lies in an interval \eqn{[a,b]}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DoubleVariable$get_size_of(a, b)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{a}}{lower bound}

\item{\code{b}}{upper bound}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-queue_update"></a>}}
\if{latex}{\out{\hypertarget{method-queue_update}{}}}
\subsection{Method \code{queue_update()}}{
Queue an update for a variable. There are 4 types of variable update:
\enumerate{
 \item{Subset update: }{The argument \code{index} represents a subset of the variable to
update. The argument \code{values} should be a vector whose length matches the size of \code{index},
which represents the new values for that subset.}
 \item{Subset fill: }{The argument \code{index} represents a subset of the variable to
update. The argument \code{values} should be a single number, which fills the specified subset.}
 \item{Variable reset: }{The index vector is set to \code{NULL} and the argument \code{values}
replaces all of the current values in the simulation. \code{values} should be a vector
whose length should match the size of the population, which fills all the variable values in
the population}
 \item{Variable fill: }{The index vector is set to \code{NULL} and the argument \code{values}
should be a single number, which fills all of the variable values in 
the population.}
}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DoubleVariable$queue_update(values, index = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{values}}{a vector or scalar of values to assign at the index}

\item{\code{index}}{is the index at which to apply the change, use \code{NULL} for the
fill options. If using indices, this may be either a vector of integers or
a \code{\link[individual]{Bitset}}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.update"></a>}}
\if{latex}{\out{\hypertarget{method-.update}{}}}
\subsection{Method \code{.update()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DoubleVariable$.update()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DoubleVariable$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
