% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.incadata.R, R/as.incadata.data.frame.R,
%   R/as.incadata.default.R
\name{as.incadata}
\alias{as.incadata}
\alias{is.incadata}
\alias{as.incadata.data.frame}
\alias{as.incadata.default}
\title{Coerce to object of class "incadata"}
\usage{
as.incadata(x, ...)

is.incadata(x)

\method{as.incadata}{data.frame}(x, decode = TRUE, id = TRUE, ask = TRUE,
  ...)

\method{as.incadata}{default}(x, n_i = NULL, ...)
}
\arguments{
\item{x}{vector or data frame with data from INCA or Rockan.}

\item{...}{arguments passed to \code{\link{exceed_threshold}}}

\item{decode}{Should \code{\link{decode}} be applied to variables with 
identified variable names? (\code{TRUE} by default).}

\item{id}{Should an id-column be added? This is based on PERSNR/PNR/PAT_ID if
available (in that order) but is not set to \code{NA} for non valid pins
(see \code{\link{as.pin}}).}

\item{ask}{ask for input if unsure how to coerce variables}

\item{n_i}{used internally}
}
\value{
\describe{
 \item{\code{as.incadata.data.frame}}{object of class
    \code{incadata} based on the "tibble"-class used within the "tidyverse"}
  \item{\code{as.incadata.default}}{
    input coerced to relevant class} 
  \item{\code{is.incadata}}{\code{TRUE} if its argument is of class 
    \code{incadata} and \code{FALSE} otherwise.}
}
}
\description{
Functions to check if an object is of class \code{incadata}, or coerce it if
possible.
}
\details{
If the function is called on a "big" data set, it might be time consuming and
it might be quite verbose about performed class transformation. It would
probably be worth the time when run locally for a specified task but if run
as production code on INCA, some caution might be advised! Use
\code{\link{suppressMessages}} to avoid the verbose output.
}
