% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcaPlot.R
\name{pcaPlot}
\alias{pcaPlot}
\title{pcaPlot}
\usage{
pcaPlot(
  logcounts,
  Sample,
  Group,
  title,
  palette,
  maxOverlaps,
  sizeLabel,
  center,
  scale
)
}
\arguments{
\item{logcounts}{Numeric matrix of log-CPM values (genes × samples), e.g., from edgeR::cpm.}

\item{Sample}{Character vector of sample names corresponding to the columns of "logcounts".}

\item{Group}{Factor or character vector denoting group/condition for each sample.}

\item{title}{Character. Title for the PCA plot.}

\item{palette}{Character. Name of a discrete color palette from the "paletteer" package.}

\item{maxOverlaps}{Integer. Maximum number of overlapping labels allowed by "ggrepel".}

\item{sizeLabel}{Numeric. Font size for sample labels.}

\item{center}{Logical. If TRUE, center variables before PCA.}

\item{scale}{Logical. If TRUE, scale variables to unit variance before PCA.}
}
\value{
A "ggplot" object displaying the PCA scatter plot of PC1 vs PC2.
}
\description{
Create a PCA scatter plot from log-expression data with sample labels.
}
\details{
This function performs Principal Component Analysis (PCA) on a log-count matrix
and visualizes the first two principal components using ggplot2 and ggrepel.
Each point represents a sample, colored by group, with hover labels.
\enumerate{
\item Transposes the "logcounts" matrix so samples are rows.
\item Runs PCA via "stats::prcomp()" with centering and scaling options.
\item Calculates percent variance explained by PC1 and PC2.
\item Builds a scatter plot with black‐bordered points and non‐overlapping labels.
}
}
