% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CorrPlotHeatmap.R
\name{CorrPlotHeatmap}
\alias{CorrPlotHeatmap}
\title{CorrPlotHeatmap}
\usage{
CorrPlotHeatmap(
  x,
  scale,
  Color,
  type,
  display,
  round_number,
  cutree_rows,
  cutree_cols,
  cluster,
  show_names,
  NumGenes
)
}
\arguments{
\item{x}{Numeric matrix of log-CPM values (genes × samples), e.g., from "edgeR::cpm()".}

\item{scale}{Character. Scaling mode for the heatmap: "row", "column", or "none".}

\item{Color}{Character. Name of a continuous palette from the "paletteer" package.}

\item{type}{Character. Correlation method passed to "Hmisc::rcorr()": "pearson", "spearman", or "kendall".}

\item{display}{Character. Which matrix to display: "correlation" (coefficients) or "pvalue".}

\item{round_number}{Integer. Number of decimal places to round displayed numbers.}

\item{cutree_rows}{Integer. Number of clusters to cut for row dendrogram.}

\item{cutree_cols}{Integer. Number of clusters to cut for column dendrogram.}

\item{cluster}{Character. Clustering mode: one of "both", "row", "column", or "none".}

\item{show_names}{Character. One of "both", "row", "column", or "none" to display row/column labels.}

\item{NumGenes}{Integer. Number of top-variance genes to include in the correlation.}
}
\value{
A "pheatmap" object representing the correlation heatmap with clustering.
}
\description{
Plot a correlation heatmap of top variable genes across samples.
}
\details{
This function selects the highest-variance genes from a log-CPM matrix, computes
pairwise correlation coefficients (or p-values) with "Hmisc::rcorr()", and renders
a heatmap via "pheatmap", with options for clustering, scaling, and number display.
\enumerate{
\item Compute per-gene variance and select the top "NumGenes".
\item Subset the matrix and compute correlations (and p-values) via "Hmisc::rcorr()".
\item Choose to display correlation coefficients or p-values, rounded to "round_number".
\item Determine clustering and label visibility from cluster and "show_names".
\item Render the heatmap with "pheatmap::pheatmap()", passing in custom distance, color,
clustering, and "display" number settings, saving to a temporary file to suppress autosave.
}
}
