% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotNA.imputations.R
\name{plotNA.imputations}
\alias{plotNA.imputations}
\title{Visualize Imputed Values}
\usage{
plotNA.imputations(x.withNA, x.withImputations, x.withTruth = NULL,
  legend = TRUE, main = "Visualization Imputed Values", xlab = "Time",
  ylab = "Value", colWithTruth = "green3", colLines = "black",
  colWithImputations = "indianred2", colWithNA = "steelblue2",
  ylim = c(min(c(x.withImputations, x.withTruth), na.rm = TRUE),
  max(c(x.withImputations, x.withTruth), na.rm = TRUE)), pch = 20,
  cex = 0.8, ...)
}
\arguments{
\item{x.withNA}{Numeric Vector or Time Series (\code{\link{ts}}) object with NAs before imputation}

\item{x.withImputations}{Numeric Vector or Time Series (\code{\link{ts}}) object with NAs replaced by imputed values}

\item{x.withTruth}{Numeric Vector or Time Series (\code{\link{ts}}) object with the real values. (can be set to NULL if not known)}

\item{legend}{If TRUE a legend is shown at the bottom of the plot. A custom legend can be obtained by
setting this parameter to FALSE and using  \code{\link[graphics]{legend}} function}

\item{main}{Main title for the plot}

\item{xlab}{Label for x axis of the plot}

\item{ylab}{Label for y axis of plot}

\item{colWithTruth}{Defines the color of the real values (truth) for the NA values.}

\item{colLines}{Defines the color of the lines connecting non-NA observations.}

\item{colWithImputations}{Defines the color for the imputed values.}

\item{colWithNA}{Defines the color of the non-NA observations.}

\item{ylim}{the y limits of the plot}

\item{pch}{Either an integer specifying a symbol or a single character to be used as the default in plotting points.}

\item{cex}{A numerical value giving the amount by which plotting text and symbols should be magnified relative to the default.}

\item{...}{Additional graphical parameters that can be passed through to plot}
}
\description{
Visualize the imputed values in a time series.
}
\details{
This plot can be used, to visualize the imputed values for a time series. Therefore, 
the imputed values (filled NA gaps) are shown in a different color than the other values.
If the real values (truth) behind the NA gaps are known these are also added in a different color.
}
\examples{
#Example 1: Visualize the values that were imputed by na.mean in the time series
impMean.Airgap <- na.mean(tsAirgap)
plotNA.imputations(tsAirgap, impMean.Airgap)


#Example 2: Visualize the values that were imputed by na.locf and the true values in the time series
impLOCF.Airgap <- na.locf(tsAirgap)
plotNA.imputations(tsAirgap, impLOCF.Airgap, tsAirgapComplete)

#Example 3: Same as example 1, just written with pipe operator
tsAirgap \%>\% na.mean \%>\% plotNA.imputations(x.withNA = tsAirgap)

}
\seealso{
\code{\link[imputeTS]{plotNA.distribution}},\code{\link[imputeTS]{plotNA.distributionBar}},
 \code{\link[imputeTS]{plotNA.gapsize}}
}
\author{
Steffen Moritz
}
