% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na.replace.R
\name{na.replace}
\alias{na.replace}
\title{Replace Missing Values by a Defined Value}
\usage{
na.replace(x, fill = 0)
}
\arguments{
\item{x}{Numeric Vector (\code{\link{vector}}) or Time Series (\code{\link{ts}}) object in which missing values shall be replaced}

\item{fill}{Value used to replace the missing values}
}
\value{
Vector (\code{\link{vector}}) or Time Series (\code{\link{ts}}) object (dependent on given input at parameter x)
}
\description{
Replaces all missing values with a given value.
}
\examples{
#Prerequisite: Create Time series with missing values
x <- ts(c(2,3,NA,5,6,NA,7,8))

#Example 1: Replace all NAs with 3.5
na.replace(x, fill = 3.5 )

#Example 2: Replace all NAs with 0
na.replace(x, fill = 0 ) 

#Example 3: Same as example 1, just written with pipe operator
x \%>\% na.replace(fill = 3.5 )

}
\seealso{
\code{\link[imputeTS]{na.interpolation}},
\code{\link[imputeTS]{na.kalman}}, \code{\link[imputeTS]{na.locf}},
 \code{\link[imputeTS]{na.ma}}, \code{\link[imputeTS]{na.mean}},
 \code{\link[imputeTS]{na.random}},
 \code{\link[imputeTS]{na.seadec}}, \code{\link[imputeTS]{na.seasplit}}
}
\author{
Steffen Moritz
}
