% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funs.R
\name{guess}
\alias{guess}
\title{Impute by (educated) guessing}
\usage{
guess(x, type = "mean")
}
\arguments{
\item{x}{a matrix or data frame}

\item{type}{is the guessing type, including "mean" for mean imputation, 
"median" for median imputation, "random" for random guess, and "majority" for
majority imputation for categorical variables.}
}
\description{
This function use some primitive methods, including mean imputation, 
median imputation, random guess, or majority imputation (only for categorical
variables), to impute a missing data matrix.
}
\examples{
data(parkinson)
# introduce some random missing values
missdata <- SimIm(parkinson, 0.1)
# impute by mean imputation
impdata <- guess(missdata)
# caculate the NRMSE
Rmse(impdata, missdata, parkinson, norm = TRUE)
# by random guessing, the NRMSE should be much bigger
impdata2 <- guess(missdata, "random")
Rmse(impdata2, missdata, parkinson, norm = TRUE)
}
