% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motif_implantation.R
\name{motif_implantation}
\alias{motif_implantation}
\title{Implant random or predefined motifs into CDR3}
\usage{
motif_implantation(sim_repertoire, motif, fixed_pos = 0)
}
\arguments{
\item{sim_repertoire}{An annotated AIRR compliant immuneSIM repertoire.}

\item{motif}{Either a list that contains number, length and frequencies of motifs or dataframe that contains predefined motifs and their frequencies}

\item{fixed_pos}{defines position at which motif is to be introduced. if 0 motif will be introduced at random position}
}
\value{
Repertoire with modified sequences containing implanted motifs in CDR3.
}
\description{
Implant random or predefined motifs into CDR3
}
\examples{
sim_repertoire <- list_example_repertoires[["example_repertoire_A"]]
sim_rep_motifs <- motif_implantation(sim_repertoire,list("n"=2,"k"=3,"freq"=c(0.1,0.1)),0)
}
