% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling.R
\name{repSample}
\alias{repSample}
\title{Downsampling and resampling of immune repertoires}
\usage{
repSample(
  .data,
  .method = c("downsample", "resample", "sample"),
  .n = NA,
  .prob = TRUE
)
}
\arguments{
\item{.data}{The data to be processed. Can be \link{data.frame},
\link{data.table}, or a list of these objects.

Every object must have columns in the immunarch compatible format.
\link{immunarch_data_format}

Competent users may provide advanced data representations:
DBI database connections, Apache Spark DataFrame from \link{copy_to} or a list
of these objects. They are supported with the same limitations as basic objects.

Note: each connection must represent a separate repertoire.}

\item{.method}{Character. Name of a sampling method. See "Description" for more details. Default value is "downsample"
that downsamples repertoires to the number of clones (i.e., reads / UMIs) that the smallest repertoire has, if user
doesn't pass any value to the ".n" argument.}

\item{.n}{Integer. Number of clones / clonotypes / reads / UMIs to choose, depending on the method. Pass NA to sample
repertoires to the size of the smallest repertoire in the ".data".}

\item{.prob}{Logical. If TRUE then sample clonotypes with probability weights equal to their number of clones. Used only if
".method" is "sample".}
}
\value{
Subsampled immune repertoires or a list of subsampled immune repertoires.
}
\description{
Sample (downsample) repertoires using different approches.
}
\details{
If \code{.method} is "downsample" then \code{repSample} chooses \code{.n} clones (not clonotypes!) from the input repertoires without any probabilistic simulation,
but exactly computing each choosed clones. Such approach is is more consistent and biologically pleasant than
an output from the function if \code{.method} is "resample".

If \code{.method} is "resample" then \code{repSample} uses multinomial distribution to compute the number of occurences for each cloneset.
then it removes zero-number clonotypes and return the resulting data frame. Probabilities for \code{rmultinom} for each cloneset
is a percentage of this cloneset in the "Proportion" column. It's a some sort of simulation of how clonotypes are chosen from the organisms.

if \code{.method} is "sample" then \code{repSample} chooses \code{.n} clonotypes (not clones!) randomly. Depending on the
\code{.prob} argument, the function chooses clonotypes either according to their size (if \code{.prob} is TRUE, by default),
or each clonotype has an equal chance to be choosed (if \code{.prob} is FALSE). Note that sampling is done without replacing.
}
\examples{
data(immdata)
# Downsampling to 1000 clones (not clonotypes!)
tmp <- repSample(immdata$data[[1]], .n = 1000)
sum(tmp$Clones)

# Downsampling to 1000 clonotypes
tmp <- repSample(immdata$data[[1]], "sample", .n = 1000)
nrow(tmp)

# Downsampling to the smallest repertoire by clones (not clonotypes!)
tmp <- repSample(immdata$data[c(1, 2)])
sum(tmp[[1]]$Clones)
sum(tmp[[2]]$Clones)

# Downsampling to the smallest repertoire by clonotypes
tmp <- repSample(immdata$data[c(1, 2)], "sample")
nrow(tmp[[1]]$Clones)
nrow(tmp[[2]]$Clones)
}
\seealso{
\link{rmultinom}, \link{clonal_proportion}
}
\concept{preprocessing}
