% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/adaptive_double_plateaus_histogram_equalization.R
\name{EqualizeADP}
\alias{EqualizeADP}
\title{Adaptive Double Plateaus Histogram Equalization}
\usage{
EqualizeADP(im, n = 5, N = 1000, range = c(0, 255),
  returnparam = FALSE)
}
\arguments{
\item{im}{a grayscale image of class cimg}

\item{n}{window size to determine local maximum}

\item{N}{the number of subintervals of histogram}

\item{range}{range of the pixel values of image. this function assumes that the range of pixel values of of an input image is [0,255] by default. you may prefer [0,1].}

\item{returnparam}{if returnparam is TRUE, returns the computed parameters: t_down and t_up.}
}
\value{
a grayscale image of class cimg or a numericvector
}
\description{
compute the paramters, t_down and t_up, and then apply double plateaus histogram equalization.
}
\examples{
g <- grayscale(dogs)
layout(matrix(1:2, 1, 2))
plot(g, main = "Original")
EqualizeADP(g) \%>\% plot(main = "Contrast Enhanced")
}
\references{
Kun Liang, Yong Ma, Yue Xie, Bo Zhou ,Rui Wang (2012). A new adaptive contrast enhancement algorithm for infrared images based on double plateaus histogram equalization. Infrared Phys. Technol. 55, 309-315.
}
\author{
Shota Ochi
}
