% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{patch_summary_cimg}
\alias{patch_summary_cimg}
\title{Extract a numerical summary from image patches, using CImg's mini-language
Experimental feature.}
\usage{
patch_summary_cimg(im, expr, cx, cy, wx, wy)
}
\arguments{
\item{im}{an image}

\item{expr}{a CImg expression (as a string)}

\item{cx}{vector of x coordinates for patch centers}

\item{cy}{vector of y coordinates for patch centers}

\item{wx}{vector of coordinates for patch width}

\item{wy}{vector of coordinates for patch height}
}
\description{
Extract a numerical summary from image patches, using CImg's mini-language
Experimental feature.
}
\examples{
\dontshow{cimg.limit.openmp()}
#Example: median filtering using patch_summary_cimg
#Center a patch at each pixel
im <- grayscale(boats)
patches <- pixel.grid(im)  \%>\% dplyr::mutate(w=3,h=3)
#Extract patch summary
out <- dplyr::mutate(patches,med=patch_summary_cimg(im,"ic",x,y,w,h))
as.cimg(out,v.name="med") \%>\% plot
}
