% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictor.R
\name{predict_lasso}
\alias{predict_lasso}
\title{Predict responses}
\usage{
predict_lasso(fit, newx, s = NULL, type = "response")
}
\arguments{
\item{fit}{IILasso model}

\item{newx}{matrix of explanatory variables}

\item{s}{selected lambda (default: all)}

\item{type}{prediction type for logistic lasso: "response" (default) or "class"}
}
\value{
prediction matrix (if s is NULL) or vector (if s is specified)
}
\description{
Predict responses
}
\examples{
X <- matrix(c(1,2,3,5,4,7,6,8,9,10), nrow=5, ncol=2)
b <- matrix(c(-1,1), nrow=2, ncol=1)
e <- matrix(c(0,-0.1,0.1,-0.1,0.1), nrow=5, ncol=1)
y <- as.numeric(X \%*\% b + e)
fit <- lasso(X, y)
pr <- predict_lasso(fit, X)
plot_lasso(fit)
}
