% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_heatmap.R
\name{setup_tooltip_options}
\alias{setup_tooltip_options}
\title{Tooltip Options}
\usage{
setup_tooltip_options(row = TRUE, col = TRUE, value = TRUE,
  prepend_row = "Row: ", prepend_col = "Col: ",
  prepend_value = "Value: ")
}
\arguments{
\item{row}{logical, include row name in tooltip?}

\item{col}{logical, include column name in tooltip?}

\item{value}{logical, includevalue in tooltip?}

\item{prepend_row}{text to prepend to row name}

\item{prepend_col}{text to prepend to column name}

\item{prepend_value}{text to prepend to value}
}
\value{
a HeatmapTooltipOptions object which stores these options and can be
passed to 'tooltip' argument to main_heatmap and other functions.
}
\description{
This function setups tooltip options for heatmap components of iheatmapr 
complex heatmaps.
}
\examples{

mat <- matrix(rnorm(20), ncol = 5, nrow = 4)  
hm1 <- main_heatmap(mat, 
   tooltip = setup_tooltip_options(row = FALSE, col = FALSE,
                                   prepend_value = "Value is ")) 

# Print heatmap if interactive session 
if (interactive()) hm1 
}
