% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iheatmap.R
\docType{methods}
\name{add_iheatmap}
\alias{add_iheatmap}
\alias{add_iheatmap,IheatmapHorizontal,matrix-method}
\alias{add_iheatmap,IheatmapVertical,matrix-method}
\alias{add_iheatmap,IheatmapVertical,matrix-method}
\title{add_iheatmap}
\usage{
\S4method{add_iheatmap}{IheatmapHorizontal,matrix}(p, data,
  x = default_x(data), cluster_cols = c("none", "hclust", "kmeans",
  "groups"), col_clusters = NULL, col_k = NULL,
  col_clust_dist = stats::dist, name = "Signal", scale = c("none", "rows",
  "cols"), scale_method = c("standardize", "center", "normalize"),
  colors = NULL, col_clusters_colors = NULL,
  col_clusters_name = "Col<br>Clusters", show_col_clusters_colorbar = TRUE,
  row_annotation = NULL, col_annotation = NULL,
  row_annotation_colors = NULL, col_annotation_colors = NULL,
  row_labels = NULL, col_labels = NULL, row_title = NULL,
  col_title = NULL, buffer = 0.2, ...)

\S4method{add_iheatmap}{IheatmapVertical,matrix}(p, data, y = default_y(data),
  cluster_rows = c("none", "hclust", "kmeans", "groups"),
  row_clusters = NULL, row_k = NULL, row_clust_dist = stats::dist,
  name = "Signal", scale = c("none", "rows", "cols"),
  scale_method = c("standardize", "center", "normalize"), colors = NULL,
  row_clusters_colors = NULL, row_clusters_name = "Col<br>Clusters",
  show_row_clusters_colorbar = TRUE, row_annotation = NULL,
  col_annotation = NULL, row_annotation_colors = NULL,
  col_annotation_colors = NULL, row_labels = NULL, col_labels = NULL,
  row_title = NULL, col_title = NULL, buffer = 0.2, ...)
}
\arguments{
\item{p}{iheatmap object}

\item{data}{matrix of values to be plotted as heatmap}

\item{x}{x xaxis labels, by default colnames of data}

\item{cluster_cols}{"none","hclust", or "k-means" for no clustering, 
hierarchical clustering, and k-means clustering of columnsrespectively}

\item{col_clusters}{vector of pre-determined column cluster assignment}

\item{col_k}{number of clusters for columns, needed if cluster_rows is kmeans 
or optional if hclust}

\item{col_clust_dist}{distance function to use for column clustering if 
hierarchical clustering}

\item{name}{Name for colorbar}

\item{scale}{scale matrix by rows, cols or none}

\item{scale_method}{what method to use for scaling, either standardize, 
center, normalize}

\item{colors}{name of RColorBrewer palette or vector of colors for main heatmap}

\item{col_clusters_colors}{colors for col clusters annotation heatmap}

\item{col_clusters_name}{name for col clusters colorbar}

\item{show_col_clusters_colorbar}{show the colorbar for column clusters?}

\item{row_annotation}{row annotation data.frame}

\item{col_annotation}{column annotation data.frame}

\item{row_annotation_colors}{list of colors for row annotations heatmap}

\item{col_annotation_colors}{list of colors for col annotations heatmap}

\item{row_labels}{axis labels for y axis}

\item{col_labels}{axis labels for x axis}

\item{row_title}{x axis title}

\item{col_title}{y axis title}

\item{buffer}{amount of space to leave empty before this plot, relative to 
size of first heatmap}

\item{...}{additional argument to add_iheatmap}

\item{y}{y axis labels, by default rownames of data}

\item{cluster_rows}{"none","hclust", or "k-means" for no clustering, 
hierarchical clustering, and k-means clustering of rows respectively}

\item{row_clusters}{vector of pre-determined row cluster assignment}

\item{row_k}{number of clusters for rows, needed if cluster_rows is kmeans or 
optional if hclust}

\item{row_clust_dist}{distance function to use for row clustering if 
hierarchical clustering}

\item{row_clusters_colors}{colors for row clusters annotation heatmap}

\item{row_clusters_name}{name for row clusters colorbar}

\item{show_row_clusters_colorbar}{show the colorbar for row clusters?}
}
\value{
\code{\link{Iheatmap-class}} object, which can be printed to generate 
an interactive graphic
}
\description{
add_iheatmap
}
\details{
By default, no scaling is done of rows or columns. This can be changed by 
specifying the 'scale' argument.  There are three options for scaling 
methods. "standardize" subtracts the mean and divides by standard deviation,
"center" just subtracts the mean, and "normalize" divides by the sum of the 
values.  "normalize" should only be used for data that is all positive!  If 
alternative scaling is desired, the scaling should be done prior to calling 
the iheatmap function.
}
\examples{

mat <- matrix(rnorm(24), nrow = 6)
mat2 <- matrix(rnorm(24), nrow = 6)
annotation = data.frame(gender = c(rep("M", 3),rep("F",3)),
                        age = c(20,34,27,19,23,30))
hm <- iheatmap(mat, 
 cluster_rows = "hclust", 
 cluster_cols = "hclust", 
 col_k = 3) \%>\%
add_iheatmap(mat2, 
 cluster_cols = "hclust", 
 col_k = 3, 
 row_annotation = annotation)

# Print heatmap if interactive session 
if (interactive()) hm 
}
\seealso{
\code{\link{iheatmap}}, \code{\link{main_heatmap}}
}
\author{
Alicia Schep
}
