% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{compose}
\alias{compose}
\alias{graph.compose}
\alias{\%c\%}
\title{Compose two graphs as binary relations}
\usage{
compose(g1, g2, byname = "auto")
}
\arguments{
\item{g1}{The first input graph.}

\item{g2}{The second input graph.}

\item{byname}{A logical scalar, or the character scalar \code{auto}. Whether
to perform the operation based on symbolic vertex names. If it is
\code{auto}, that means \code{TRUE} if both graphs are named and
\code{FALSE} otherwise. A warning is generated if \code{auto} and one graph,
but not both graphs are named.}
}
\value{
A new graph object.
}
\description{
Relational composition of two graph.
}
\details{
\code{compose()} creates the relational composition of two graphs. The
new graph will contain an (a,b) edge only if there is a vertex c, such that
edge (a,c) is included in the first graph and (c,b) is included in the
second graph. The corresponding operator is \verb{\%c\%}.

The function gives an error if one of the input graphs is directed and the
other is undirected.

If the \code{byname} argument is \code{TRUE} (or \code{auto} and the graphs
are all named), then the operation is performed based on symbolic vertex
names. Otherwise numeric vertex ids are used.

\code{compose()} keeps the attributes of both graphs. All graph, vertex
and edge attributes are copied to the result. If an attribute is present in
multiple graphs and would result a name clash, then this attribute is
renamed by adding suffixes: _1, _2, etc.

The \code{name} vertex attribute is treated specially if the operation is
performed based on symbolic vertex names. In this case \code{name} must be
present in both graphs, and it is not renamed in the result graph.

Note that an edge in the result graph corresponds to two edges in the input,
one in the first graph, one in the second. This mapping is not injective and
several edges in the result might correspond to the same edge in the first
(and/or the second) graph. The edge attributes in the result graph are
updated accordingly.

Also note that the function may generate multigraphs, if there are more than
one way to find edges (a,b) in g1 and (b,c) in g2 for an edge (a,c) in the
result. See \code{\link[=simplify]{simplify()}} if you want to get rid of the multiple
edges.

The function may create loop edges, if edges (a,b) and (b,a) are present in
g1 and g2, respectively, then (a,a) is included in the result. See
\code{\link[=simplify]{simplify()}} if you want to get rid of the self-loops.
}
\examples{

g1 <- make_ring(10)
g2 <- make_star(10, mode = "undirected")
gc <- compose(g1, g2)
print_all(gc)
print_all(simplify(gc))

}
\seealso{
Other functions for manipulating graph structure: 
\code{\link{+.igraph}()},
\code{\link{add_edges}()},
\code{\link{add_vertices}()},
\code{\link{complementer}()},
\code{\link{connect}()},
\code{\link{contract}()},
\code{\link{delete_edges}()},
\code{\link{delete_vertices}()},
\code{\link{difference.igraph}()},
\code{\link{difference}()},
\code{\link{disjoint_union}()},
\code{\link{edge}()},
\code{\link{igraph-minus}},
\code{\link{intersection.igraph}()},
\code{\link{intersection}()},
\code{\link{path}()},
\code{\link{permute}()},
\code{\link{rep.igraph}()},
\code{\link{reverse_edges}()},
\code{\link{simplify}()},
\code{\link{union.igraph}()},
\code{\link{union}()},
\code{\link{vertex}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{functions for manipulating graph structure}
\keyword{graphs}
