% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foreign.R
\name{write_graph}
\alias{write_graph}
\alias{write.graph}
\title{Writing the graph to a file in some format}
\usage{
write_graph(
  graph,
  file,
  format = c("edgelist", "pajek", "ncol", "lgl", "graphml", "dimacs", "gml", "dot",
    "leda"),
  ...
)
}
\arguments{
\item{graph}{The graph to export.}

\item{file}{A connection or a string giving the file name to write the graph
to.}

\item{format}{Character string giving the file format. Right now
\code{pajek}, \code{graphml}, \code{dot}, \code{gml}, \code{edgelist},
\code{lgl}, \code{ncol} and \code{dimacs} are implemented. As of igraph 0.4
this argument is case insensitive.}

\item{\dots}{Other, format specific arguments, see below.}
}
\value{
A NULL, invisibly.
}
\description{
\code{write_graph()} is a general function for exporting graphs to foreign
file formats, however not many formats are implemented right now.
}
\section{Edge list format}{
 The \code{edgelist} format is a simple text file,
with one edge in a line, the two vertex ids separated by a space character.
The file is sorted by the first and the second column. This format has no
additional arguments.
}

\examples{

g <- make_ring(10)
file <- tempfile(fileext = ".txt")
write_graph(g, file, "edgelist")
if (!interactive()) {
  unlink(file)
}

}
\references{
Adai AT, Date SV, Wieland S, Marcotte EM. LGL: creating a map of
protein function with an algorithm for visualizing very large biological
networks. \emph{J Mol Biol.} 2004 Jun 25;340(1):179-90.
}
\seealso{
\code{\link[=read_graph]{read_graph()}}

Other foreign: 
\code{\link{graph_from_graphdb}()},
\code{\link{read_graph}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{foreign}
\keyword{graphs}
