% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.R
\name{make_lattice}
\alias{make_lattice}
\alias{graph.lattice}
\alias{lattice}
\title{Create a lattice graph}
\usage{
make_lattice(dimvector = NULL, length = NULL, dim = NULL, nei = 1,
  directed = FALSE, mutual = FALSE, circular = FALSE)

lattice(...)
}
\arguments{
\item{dimvector}{A vector giving the size of the lattice in each
dimension.}

\item{length}{Integer constant, for regular lattices, the size of the
lattice in each dimension.}

\item{dim}{Integer constant, the dimension of the lattice.}

\item{nei}{The distance within which (inclusive) the neighbors on the
lattice will be connected. This parameter is not used right now.}

\item{directed}{Whether to create a directed lattice.}

\item{mutual}{Logical, if \code{TRUE} directed lattices will be
mutually connected.}

\item{circular}{Logical, if \code{TRUE} the lattice or ring will be
circular.}

\item{...}{Passed to \code{make_lattice}.}
}
\value{
An igraph graph.
}
\description{
\code{make_lattice} is a flexible function, it can create lattices of
arbitrary dimensions, periodic or unperiodic ones. It has two
forms. In the first form you only supply \code{dimvector}, but not
\code{length} and \code{dim}. In the second form you omit
\code{dimvector} and supply \code{length} and \code{dim}.
}
\examples{
make_lattice(c(5, 5, 5))
make_lattice(length = 5, dim = 3)
}
\seealso{
Other determimistic constructors: \code{\link{graph_from_atlas}},
  \code{\link{graph_from_edgelist}},
  \code{\link{graph_from_literal}},
  \code{\link{make_chordal_ring}},
  \code{\link{make_empty_graph}},
  \code{\link{make_full_citation_graph}},
  \code{\link{make_full_graph}}, \code{\link{make_graph}},
  \code{\link{make_ring}}, \code{\link{make_star}},
  \code{\link{make_tree}}
}
\concept{
Lattice
}
