% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sat_vapor_pressure.R
\encoding{UTF-8}
\name{unit_wt}
\alias{unit_wt}
\title{Unit Weight or Specific Weight}
\usage{
unit_wt(rho, units = c("SI", "Eng"), Eng_units = c("slug/ft^3", "lbm/ft^3"))
}
\arguments{
\item{rho}{numeric vector that contains the density}

\item{units}{character vector that contains the system of units {options are
\code{SI} for International System of Units or \code{Eng} for English units
(United States Customary System in the United States and Imperial Units in
the United Kingdom)}}

\item{Eng_units}{character vector that contains the density English units
{options are \code{lbm/ft^3} or \code{slug/ft^3}}}
}
\value{
the unit weight or specific weight as a numeric vector. The units are
  not returned.
}
\description{
This function solves for the unit weight or specific weight of a substance
using only the substance's density and gravitational acceleration.
}
\details{
The equation is expressed as

\deqn{\\gamma = \frac{m * g}{V} = \\rho * g = \\rho * \frac{g}{gc}}

\describe{
  \item{\emph{\\gamma}}{unit weight or specific weight (N/m^3 or lbf/ft^3)}
  \item{\emph{m}}{substance mass (kg, lbm, or slugs)}
  \item{\emph{g}}{gravitational acceleration (m/s^2 or ft/sec^2)}
  \item{\emph{gc}}{"unit conversion factor used to convert mass to force or vice versa" (lbm-ft/lbf-sec^2)}
  \item{\emph{V}}{the volume of the substance (m^3 or ft^3)}
  \item{\emph{\\rho}}{substance density (mass divided by volume) [kg/m^3, slug/ft^3", or lbm/ft^3]}
}
}
\examples{
# Examples

library(iemisc)

rho1 <- density_water(T = 68, units = "Eng", Eng_units = "slug/ft^3")

unit_wt(rho = rho1, units = "Eng", Eng_units = "slug/ft^3")


rho2 <- density_water(T = 68, units = "Eng", Eng_units = "lbm/ft^3")

unit_wt(rho = rho2, units = "Eng", Eng_units = "lbm/ft^3")


rho3 <- density_water(T = 20, units = "SI")

unit_wt(rho = rho3, units = "SI")




}
\references{
\enumerate{
   \item The Engineering ToolBox, 27 March 2022, "Water - Density, Specific Weight and Thermal Expansion Coefficients", \url{https://www.engineeringtoolbox.com/water-density-specific-weight-d_595.html}
   \item WikiEngineer, 27 March 2022, "Water Properties & Definitions", \url{https://web.archive.org/web/20210412034245/http://www.wikiengineer.com/Water-Resources/PropertiesAndDefinitions}. Retrieved thanks to the Internet Archive: Wayback Machine
   \item Wikimedia Foundation, Inc. Wikipedia, 27 March 2022, "gc (engineering)", \url{https://en.wikipedia.org/wiki/Gc_(engineering)}.
   \item Wikimedia Foundation, Inc. Wikipedia, 27 March 2022, "Specific weight", \url{https://en.wikipedia.org/wiki/Specific_weight}.
}
}
\author{
Irucka Embry
}
