% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rain_garden_driveway.R
\encoding{UTF-8}
\name{rain_garden_driveway}
\alias{rain_garden_driveway}
\title{Rain Garden Sizing for Driveways}
\usage{
rain_garden_driveway(
  dw_length = NULL,
  dw_width = NULL,
  rf_length = NULL,
  rf_width = NULL,
  driveway_table = NULL,
  roof_table = NULL,
  lw_units = c("inch", "feet", "survey_foot", "yard", "mile", "centimeter", "meter",
    "kilometer"),
  rainfall_depth,
  rainfall_depth_units = c("inch", "feet", "centimeter", "meter"),
  rain_garden_depth,
  rain_garden_depth_units = c("inch", "feet", "centimeter", "meter")
)
}
\arguments{
\item{dw_length}{numeric vector containing the length value(s) in one of the
lw_units values for the driveway(s).}

\item{dw_width}{numeric vector containing the width value(s) in one of the
lw_units values for the driveway(s).}

\item{rf_length}{numeric vector containing the length value(s) in one of the
lw_units values for the roof(s).}

\item{rf_width}{numeric vector containing the width value(s) in one of the
lw_units values for the roof(s).}

\item{driveway_table}{data.frame/data.table/tibble, list, or matrix
containing the length in column 1 and the width in column 2 for the
driveway(s).}

\item{roof_table}{data.frame/data.table/tibble, list, or matrix
containing the length in column 1 and the width in column 2 for the
roof(s).}

\item{lw_units}{character vector containing the units for the length and the
width (default = "feet"). The other possible units are "inch",
"survey_foot", "yard", "mile", "centimeter", "meter", or "kilometer". The
units should be consistent and not mixed.}

\item{rainfall_depth}{numeric vector containing the rainfall depth in one of
the rainfall_depth_units.}

\item{rainfall_depth_units}{character vector containing the units for the
rainfall depth (default = "feet"). The other possible units are "inch",
"centimeter", or "meter".}

\item{rain_garden_depth}{numeric vector containing the rain garden depth in
one of the rain_garden_depth_units.}

\item{rain_garden_depth_units}{character vector containing the units for the
rain garden depth (default = "feet"). The other possible units are "inch",
"centimeter", or "meter".}
}
\value{
a \code{\link[data.table]{data.table}} with the following columns:
   Driveway Drainage Area, One-Quarter of Roof Area, Depth of Rain, Design
   Storm Volume, Rain Garden Depth, Rain Garden Initial Size, Rain Garden
   Initial Dimensions, Total Drainage Area, New Design Storm Volume, Rain
   Garden Final Size, Rain Garden Final Dimensions
}
\description{
This function computes the final rain garden dimensions based on the size of
the impervious roof surfaces and the initial rain garden size. This function
uses the \code{\link{surface_area}} values and units in the calculations.
}
\examples{

# Note: the units must be consistent for the lengths and widths

# Example 1 (from the Reference)

library(iemisc)

dw_width1 <- c(15, 10)
dw_length1 <- c(50, 25)
lw_units <- "feet"
rf_width1 <- 50
rf_length1 <- 25
rainfall_depth1 <- 1.5
rainfall_depth_units <- "inch"
rain_garden_depth <- 6
rain_garden_depth_units <- "inch"

rain_garden_driveway(dw_length = dw_length1, dw_width = dw_width1, rf_length =
rf_length1, rf_width = rf_width1, lw_units = lw_units, rainfall_depth =
rainfall_depth1, rainfall_depth_units = rainfall_depth_units, rain_garden_depth
= rain_garden_depth, rain_garden_depth_units = rain_garden_depth_units)



# Example 2
# from https://www.ecoccs.com/R_Examples/Simple-Rain-Garden-Sizing_with-R.html
# Irucka Embry modified the Example from the Reference for this example

install.load::load_package("iemisc", "data.table")

dw_length2 <- c(construction_decimal("50 feet 3 1/2 inch", result <- "traditional",
output <- "vector"), construction_decimal("25 feet 5 7/8 inch", result <- "traditional",
output <- "vector"))
dw_width2 <- c(construction_decimal("15 feet 10 3/4 inch", result <- "traditional",
output <- "vector"), construction_decimal("10 feet 7 3/8 inch", result <- "traditional",
output <- "vector"))
lw_units <- "feet"
rf_length2 <- construction_decimal("25 feet 10 1/4 inch", result <- "traditional",
output <- "vector")
rf_width2 <- construction_decimal("12.5 feet 1 1/8 inch", result <- "traditional",
output <- "vector") * 4
rainfall_depth2 <- 2.25
rainfall_depth_units <- "inch"
rain_garden_depth <- 6
rain_garden_depth_units <- "inch"

driveway_table <- data.table(length = dw_length2, width = dw_width2)

roof_table <- data.table(length = rf_length2, width = rf_width2)

rain_garden_driveway(driveway_table = driveway_table, roof_table = roof_table,
lw_units = lw_units, rainfall_depth = rainfall_depth2, rainfall_depth_units =
rainfall_depth_units, rain_garden_depth = rain_garden_depth,
rain_garden_depth_units = rain_garden_depth_units)



}
\references{
Green Infrastructure Champion Training: Part 7: "How To Design and Build a Rain Garden", April 10, 2019, pages 41 - 43 of the PDF document, \url{https://water.rutgers.edu/Projects/GreenInfrastructureChampions/Talks_2020/Part_7_04102020.pdf}.
}
\seealso{
\code{\link{surface_area}} for calculating the linear surface area
}
\author{
Irucka Embry
}
