% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concr_mix_lightweight_strength.R
\encoding{UTF-8}
\name{concr_mix_lightweight_strength}
\alias{concr_mix_lightweight_strength}
\title{Concrete Mix Design for Structural Lightweight Concrete}
\source{
\enumerate{
   \item r - Error when doing bilinear interpolation with 'interp2 {pracma}'; any better way for 2D interpolation? - Stack Overflow answered and edited by Zheyuan Li on Dec 8 2016. See \url{https://stackoverflow.com/questions/41032225/error-when-doing-bilinear-interpolation-with-interp2-pracma-any-better-way}.
   \item r - data.table 1.10.0 - why does a named column index value not work while a integer column index value works without with = FALSE - Stack Overflow answered and edited by Matt Dowle on Dec 8 2016. See \url{https://stackoverflow.com/questions/41032225/error-when-doing-bilinear-interpolation-with-interp2-pracma-any-better-way}.
}
}
\usage{
concr_mix_lightweight_strength(
  fc,
  slump_use = NULL,
  max_size_aggr,
  FM,
  sgf_coarse,
  dry_rod_wt_aggr,
  absorp_coarse,
  absorp_fine,
  entrainment = c("Nonair", "Air"),
  construction_type = c("Beams and reinforced walls", "Building columns", "Floor slabs"),
  slump_value = c("Maximum", "Maximum + 1", "Minimum", "Minimum + 1"),
  exposure = c("Mild", "Moderate", "Extreme"),
  structure_type = c("Thin section", "Other"),
  severe_exposure = c("Wet", "Sea water"),
  trial_batch = c("1 cubic yard", "1 cubic foot", "0.5 cubic foot", "0.2 cubic foot",
    "All")
)
}
\arguments{
\item{fc}{numeric vector that contains the concrete compressive strength
(psi)}

\item{slump_use}{numeric vector that contains the amount of slump (in)}

\item{max_size_aggr}{numeric vector that contains the maximum aggregate size
(in)}

\item{FM}{numeric vector that contains the "Fineness Modulus of sand"
(dimensionless)}

\item{sgf_coarse}{numeric vector that contains the "specific gravity factor"
of the coarse aggregate (dimensionless)}

\item{dry_rod_wt_aggr}{numeric vector that contains the dry rodded weight of
aggregate {"oven-dry loose weight of coarse aggregate"} (lb/ft^3)}

\item{absorp_coarse}{numeric vector that contains the absorption of the
coarse aggregate (whole number percent)}

\item{absorp_fine}{numeric vector that contains the absorption of the
fine aggregate (whole number percent)}

\item{entrainment}{character vector that contains either Air or Nonair
entrainment}

\item{construction_type}{character vector that contains the intended type of
construction}

\item{slump_value}{character vector that contains the slump value (Maximum,
Maximum + 1, Minimum, or Minimum + 1). It is "+ 1 in. for methods of
consolidation other than vibration"}

\item{exposure}{character vector that contains the exposure value (Mild,
Moderate, or Extreme) for use with Air entrained concrete mixes}

\item{structure_type}{character vector that contains the severe exposure
value {"Thin sections (railings, curbs, sills, ledges, ornamental work) and
sections with less than 1 in. cover over steel" or "All other structures"}
for use with Air entrained concrete mixes with severe exposure}

\item{severe_exposure}{character vector that contains the severe exposure
value ("Structure wet continuously or frequently and exposed to freezing and
thawing" or "Structure exposed to sea water or sulfates") for use with Air
entrained concrete mixes with severe exposure}

\item{trial_batch}{character vector that contains the volume of the trial
batch mix to return (1 cubic yard, 1 cubic foot, 0.5 cubic foot, 0.2
cubic foot, or All)}
}
\value{
the amounts of cement, sand, gravel, and water in lb, rounded to the
   hundredth, as a \code{\link[base]{list}} to make 1 yd^3, 1 ft^3, 0.5 ft^3,
   or 0.2 ft^3 of structural lightweight concrete or as a \code{\link[data.table]{data.table}} containing
   all batch volumes.
}
\description{
Calculates the amount of cement, sand, gravel, and water needed for a test
batch volume of structural lightweight concrete using the weight method.
Note: Currently, this function only works with air-entrained concrete as the
author has not found a table to compute the weight of concrete for nonair-
entrained concrete.
}
\examples{

library("iemisc")

# Example A from Section 3.2.3 using the 'Weight method (specific gravity
# pycnometers)' from ACI Committee 211
# Design a concrete mix for 3500 psi concrete strength, 'floor slab of a
# multistory structure subjected to freezing and thawing during
# construction', and a maximum size of aggregate = 3/4 in, with Fineness
# Modulus of sand = 2.80, 'the oven-dry loose weight of coarse aggregate' =
# 47 lb/ft^3 with a specific gravity factor = 1.50, and a absorption of
# 11.0\\% for the coarse aggregate and 1.0\\% for the fine aggregate.

concr_mix_lightweight_strength(fc = 3500, max_size_aggr = 3 / 4, FM = 2.80,
sgf_coarse = 1.50, dry_rod_wt_aggr = 47, absorp_coarse = 11.0,
absorp_fine = 1.0, entrainment = "Air", construction_type = "Floor slabs",
slump_value = "Maximum", exposure = "Extreme", structure_type = "Other",
severe_exposure = "Wet", trial_batch = "1 cubic foot")


}
\references{
ACI Committee 211, \emph{Standard Practice for Selecting Proportions for Structural Lightweight Concrete (ACI 211.2-98)}, American Concrete Institute, Farmington Hills, MI, 18 pages. 1998, 211.2-98.
}
\seealso{
\code{\link{concr_mix_normal_strength}} for Concrete Mix Design for Normal Strength
(Normal-weight) Concrete
}
\author{
Irucka Embry, Hans Werner Borchers for the interp1 and interp2 functions from pracma
}
