% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Re.R
\encoding{UTF-8}
\name{Re4}
\alias{Re4}
\title{Calculating the Reynolds Number 4}
\usage{
Re4(Q, nu, D)
}
\arguments{
\item{Q}{numeric vector that contains the discharge value of the fluid
(m^3/s or ft^3/s)  {Reference: Lindeburg Manual}}

\item{nu}{numeric vector that contains the kinematic viscosity of the fluid
(m^2/s or lbf-sec/ft^2)  {Reference: Lindeburg Manual}}

\item{D}{numeric vector that contains the hydraulic diameters "(four times
the area in flow divided by the wetted surface) is a characteristic
length" (m or ft)  {Reference: Lindeburg Manual}}
}
\value{
the Reynolds number as a numeric \code{\link[base]{vector}} for Re4
}
\description{
Calculating the Reynolds Number 4
}
\examples{

# part of Example 3 from Subramanian Pipe Flow Calculations

# Q = 2.23 * 10 ^ - 2 ft^3/s
# nu = 2.40 * 10 ^ -5 ft^2/s
# D = 9.03 * 10 ^ -2 ft

library("iemisc")

Re4(Q = 2.23 * 10 ^ -2, nu = 2.40 * 10 ^ -5, D = 9.03 * 10 ^ -2)


}
\seealso{
\code{\link{Re1}} for the additional seealso, description, details, note, and references sections, \code{\link{Re2}}, \code{\link{Re3}}
}
\author{
Irucka Embry
}
