% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PgivenG.R
\encoding{UTF-8}
\name{PgivenG}
\alias{PgivenG}
\title{Present value given Gradient value (Engineering Economics)}
\usage{
PgivenG(
  G,
  n,
  i,
  frequency = c("annual", "semiannual", "quarter", "bimonth", "month", "daily")
)
}
\arguments{
\item{G}{numeric vector that contains the gradient value(s)}

\item{n}{numeric vector that contains the period value(s)}

\item{i}{numeric vector that contains the interest rate(s) as a percent}

\item{frequency}{character vector that contains the frequency used to
obtain the number of periods [annual (1), semiannual (2), quarter (4),
bimonth (6), month (12), daily (365)]}
}
\value{
PgivenG numeric vector that contains the present value(s) rounded to
   2 decimal places
}
\description{
Compute P given G
}
\details{
\deqn{P = G\left\lbrace \frac{1}{i} \left[\frac{\left(1 + i\right)^n - 1}{i\left(1 + i\right)^n} - \frac{n}{\left(1 + i\right)^n}\right]\right\rbrace }

\describe{
\item{\emph{P}}{the "present equivalent"}
\item{\emph{G}}{the "uniform gradient amount"}
\item{\emph{i}}{the "effective interest rate per interest period"}
  \item{\emph{n}}{the "number of interest periods"}
}
}
\examples{
library("iemisc")
# Example 4-20 from the Reference text (pages 153-154)
PgivenG(1000, 4, 15, "annual") # the interest rate is 15\%




}
\references{
William G. Sullivan, Elin M. Wicks, and C. Patrick Koelling, \emph{Engineering Economy}, Fourteenth Edition, Upper Saddle River, New Jersey: Pearson/Prentice Hall, 2009, page 142, 150, 152-154.
}
