% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convU.r
\name{convU}
\alias{convU}
\title{Intrinsic Dimension Estimation with Convergence Property of a U-statistics.}
\usage{
convU(x, maxDim = 5, DM = FALSE)
}
\arguments{
\item{x}{data matrix or distance matrix given by as.matrix(dist(x)).}

\item{maxDim}{maximum of the candidate dimension.}

\item{DM}{whether \code{'x'} is distance matrix or not. logical.}
}
\value{
Estimated global intrinsic dimension.
}
\description{
\code{convU} estimates intrinsic dimension of given dataset based on 
the convergence property of Ustatistics(smoothed correlation dimension)
 w.r.t. kernel bandwidth
}
\details{
A variant of fractal dimension called the correlation dimension is considered.
The correlation dimension is defined by the notion of the correlation integral, which 
is calculated by counting the number of pairs closer than certain threshold epsilon.
The counting operation is replaced with the kernel smoothed version, and based on
the convergence property of the resulting U-statistics, an intrinsic dimension estimator is derived.
}
\examples{
x <- gendata(DataName='SwissRoll',n=300)
estconvU <- convU(x=x)
print(estconvU)
}
\references{
M. Hein and J-Y. Audibert. Intrinsic dimensionality estimation of
submanifolds in Rd. International Conference on Machine Learning, 2005.
}
\author{
Hideitsu Hino \email{hideitsu.hino@gmail.com}
}
