% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/application.R, R/layers.R
\docType{methods}
\name{resample,Raster,trigrid-method}
\alias{Raster-trigrid-resample-method}
\alias{facelayer-trigrid-resample-method}
\alias{resample,Raster,trigrid-method}
\alias{resample,facelayer,trigrid-method}
\title{Resampling of data to a trigrid or a hexagrid object.}
\usage{
\S4method{resample}{Raster,trigrid}(x, y, method = "ngb", na.rm = TRUE)

\S4method{resample}{facelayer,trigrid}(x, y, method = NULL, res = 5)
}
\arguments{
\item{x}{a \code{facelayer} class object.}

\item{y}{a \code{hexagrid} or \code{trigrid} object.}

\item{method}{Character string stating the name of the algorithm used for resampling.}

\item{na.rm}{logical value. If a face contains a missing value, should its value be NA as well (FALSE) or calculate the mean anyway (TRUE).}

\item{res}{Numeric value, indicating the precision of area estimation during the upscaling. In case the "ebaa" method is chosen, the variable indicate the number of breaking points on an edge.}
}
\value{
A named numeric vector.
}
\description{
The function is used to resolve and resample data stored in RasterLayers and facelayers so they can be fitted to and can be plotted by using trigrid or hexagrid objects.

This function will calculate values for a different resolution icosahedral grid from a facelayer.
}
\details{
This method is necessary to utilize rasterized data in the icosa package. The only method currently implemented upscales the raster data and then resolve the values to the trigrid or hexagrid values, using averages. In the case of resampling rasterlayers, the method argument will be passed to the raster::resample() function.

The function applies different resampling algorithms. Currently there are only two implemented methods, one for upscaling and one for downscaling. The downscaling method "average" will tabluate all face centers from the high resolution grid that fall on a coarse resolution cell and average them. The upscaling method "ebaa" (edge breakpoint area approximation) will estimate the areas covered by the high resolution cells using the number of edge breakpoints.
}
\examples{
	g <- trigrid(c(4,4))
	fl <- facelayer(g)
	fl@values<-rnorm(length(fl))
	h <- trigrid(4)
	res <- resample(fl, h)
	fl2<-facelayer(h)
	fl2@values[] <- res

}

