% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/application.R, R/layers.R
\docType{methods}
\name{gridgraph}
\alias{gridgraph}
\alias{gridgraph,facelayer-method}
\alias{gridgraph,hexagrid-method}
\alias{gridgraph,trigrid-method}
\alias{gridgraph-facelayer-method}
\alias{gridgraph-hexagrid-method}
\alias{gridgraph-trigrid-method}
\title{Create or instantiate an 'igraph' class graph from the faces of an icosahedral grid}
\usage{
gridgraph(x, ...)

\S4method{gridgraph}{trigrid}(x, directed = FALSE, distances = FALSE)

\S4method{gridgraph}{hexagrid}(x, directed = FALSE, distances = FALSE)

\S4method{gridgraph}{facelayer}(x)
}
\arguments{
\item{x}{the icosahedral grid or facelayer.}

\item{...}{arguments passed to the class specific methods.}

\item{directed}{logical value, defaults to FALSE creating an undirected graph. If TRUE than the graph will be directed.}

\item{distances}{logical values, defaults to FALSE. If TRUE than the distances between the linked faces will be calculated and will be rendered to the edges as [["dist"]].}
}
\value{
The function returns an undirected igraph graph.

The function returns an 'igraph' graph.

The function returns an 'igraph' graph.

The function returns an 'igraph' graph.
}
\description{
The function can be applied to both grids and facelayers.

The function can be applied to a trigrid class object.

The function can be applied to a hexagrid class object.

The function can be applied to a facelayer class object of logical values. The resulting graph will have the characteristics of the original grid (directed/undirected etc.).
}

