% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-attributes.R
\name{centers}
\alias{centers}
\alias{centers,trigrid-method}
\alias{centers,facelayer-method}
\title{The face centers of an icosahedral grid object}
\usage{
centers(x, ...)

\S4method{centers}{trigrid}(x, output = "polar")

\S4method{centers}{facelayer}(x, output = "polar")
}
\arguments{
\item{x}{(\code{\link{trigrid}}, \code{\link{hexagrid}} or \code{\link{facelayer}}). The grid or linked data layer object.}

\item{...}{Arguments passed to the class specific methods.}

\item{output}{(\code{character}) The coordinate system of the output. Either \code{"polar"} or \code{"cartesian"}.}
}
\value{
The coordinates of the face centers as a \code{numeric} matrix.
}
\description{
Shorthand function to return the \code{@faceCenters} slot of an icosahedral grid or a grid linked to a facelayer.
}
\examples{
a <- trigrid()
centers(a)
}
