% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/period.R
\name{period}
\alias{period}
\title{Period}
\usage{
period(x, y = NULL)
}
\arguments{
\item{x}{the first year, vector of years, matrix, or data frame.}

\item{y}{the last year, if \code{x} is only the first year.}
}
\value{
A string of the form \code{"1990-2000"}.
}
\description{
Paste two years to form a \code{period} string.
}
\details{
If \code{x} is a vector or a data frame, then the lowest and highest years
are used, and \code{y} is ignored.

If \code{x} is a matrix or data frame, this function looks for years in the
first column. If the values of the first column do not look like years (four
digits), then it looks for years in the row names.
}
\note{
This function can be useful when working with \code{\link{draft.data}}.
}
\examples{
period(1963, 1970)
period(c(1963, 1970))
period(1963:1970)

period(range(catage.taf$Year))
period(catage.taf$Year)
period(catage.taf)
period(catage.xtab)
period(catage.long)

}
\seealso{
\code{\link{paste}} is the underlying function to paste strings.

\code{\link{draft.data}} has an argument called \code{period}.

\code{\link{icesTAF-package}} gives an overview of the package.
}
