% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeTAF.R
\name{makeTAF}
\alias{makeTAF}
\title{Run TAF Script If Needed}
\usage{
makeTAF(script, ...)
}
\arguments{
\item{script}{TAF script filename.}

\item{\dots}{passed to \code{\link{make}} and \code{\link{sourceTAF}}.}
}
\value{
\code{TRUE} or \code{FALSE}, indicating whether the script was run.
}
\description{
Run a TAF script if the target directory is either older than the script, or
older than the directory of the previous TAF step.
}
\note{
Any underlying scripts are automatically included if they share the same
filename prefix, followed by an underscore. For example, when determining
whether a script \verb{data.R} should be run, this function checks whether
\verb{data_foo.R} and \verb{data_bar.R} have been recently modified.
}
\examples{
\dontrun{
makeTAF("model.R")
}

}
\seealso{
\code{\link{source}} runs any R script, \code{\link{sourceTAF}} is more
convenient for running a TAF script, and \code{\link{sourceAll}} runs all TAF
scripts.

\code{\link{make}}, \code{\link{makeTAF}}, and \code{\link{makeAll}} are
similar to the \code{source} functions, except they avoid repeating tasks
that have already been run.

\code{\link{icesTAF-package}} gives an overview of the package.
}
