% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/filter.R
\name{icd9FilterInvalid}
\alias{icd9FilterInvalid}
\title{Filter ICD-9 codes by invalidity.}
\usage{
icd9FilterInvalid(icd9df, icd9Field = "icd9",
  isShort = icd9GuessIsShort(icd9df[[icd9Field]]), invert = FALSE)
}
\arguments{
\item{icd9df}{data frame containing columns for visitId (which is the feault
name), icd9 (default for the icd9 code), and  maybe also a POA flag.}

\item{icd9Field}{The column in the data frame which contains the ICD-9 codes.
This is a character vector of length one.}

\item{isShort}{single logical value which determines whether the ICD-9 code
provided is in short (TRUE) or decimal (FALSE) form. Where reasonable, this
is guessed from the input data.}

\item{invert}{single logical value, if TRUE will return valid instead of invalid rows.}
}
\description{
Filters a data.frame of patients for valid or invalid ICD-9 codes
}

