% Generated by roxygen2 (4.0.1): do not edit by hand
\name{icd9ExpandRangeDecimal}
\alias{\%i9d\%}
\alias{icd9ExpandRangeDecimal}
\title{expand range of ICD-9 decimal codes to all possible intermediate and sub-codes}
\usage{
icd9ExpandRangeDecimal(start, end, invalidAction = c("stop", "ignore",
  "silent", "warn"))

start \%i9d\% end
}
\arguments{
\item{invalidAction}{character string (unit length) containing one of:
  "ignore", "silent", "warn", "stop"

  - \code{ignore} no check for validity of ICD-9 code is made implicitly.
  This is the fastest option. If the function call is explicitly to check
  validity, e.g. icd9ValidShort(icd9Short = "12345", invalidAction =
  "ignore"), then the behavior is the same as \code{silent}.

  - \code{silent} invalid ICD-9 codes are replaced silently by \code{NA}
  (actually \code{NA_character_}). If the function returns \code{TRUE} or
  \code{FALSE} rather than the ICD-9 code itself, then \code{FALSE} is
  returned

  - \code{warn} invalid ICD-9 codes are replaced by \code{NA} with a warning
  revealing the invalid code(s).

  - \code{stop} stop with error if any invalid codes are found in input. This
  is the preferred method when doing one-time validation, e.g. of the
  co-morbidity mapping lists.}
}
\description{
As with \code{link{icd9ExpandRangeShort}} great care is taken not to include codes which have children not in the range. E.g. "100.9" to "101.1" would _not_ include code "101".
}
\seealso{
Other ICD-9 ranges: \code{\link{\%i9mj\%}};
  \code{\link{\%i9s\%}},
  \code{\link{icd9ExpandRangeShort}};
  \code{\link{icd9ChildrenDecimal}};
  \code{\link{icd9Children}},
  \code{\link{icd9ChildrenShort}};
  \code{\link{icd9CondenseShort}};
  \code{\link{icd9CondenseToExplainShort}};
  \code{\link{icd9ExpandMinor}},
  \code{\link{icd9ExpandMinorE}},
  \code{\link{icd9ExpandMinorNV}};
  \code{\link{icd9PrecedingMinors}},
  \code{\link{icd9SubsequentMinors}}
}
\keyword{internal}
\keyword{manip}

