% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse-ahrq-ccs.R
\name{icd9_parse_ahrq_ccs}
\alias{icd9_parse_ahrq_ccs}
\title{parse AHRQ CCS for mapping}
\usage{
icd9_parse_ahrq_ccs(single = TRUE, save_data = FALSE, offline = TRUE)
}
\arguments{
\item{single}{a logical value, if \code{TRUE} then use single level CCS,
otherwise use multi level}

\item{save_data}{logical whether to save the result in the source tree.
Defaults to \code{FALSE}.}

\item{offline}{single logical, if \code{TRUE} then don't pull the file from
internet, only return path and file name if the file already exists in the
raw data directory. This is helpful for testing without using the internet.}
}
\description{
Data is downloaded from AHRQ website. ICD9 codes were frozen so no updates
are needed. CCS codes are available in a Multi level format and a Single
level format. Single level is most common for risk adjustment (Ex. CMS
Readmission metric)
}
\examples{
\dontrun{
  icd:::icd9_parse_ahrq_ccs(single = TRUE, save_data = FALSE, offline = FALSE)
  icd:::icd9_parse_ahrq_ccs(single = TRUE, save_data = FALSE, offline = TRUE)
  icd:::icd9_parse_ahrq_ccs(single = FALSE, save_data = FALSE, offline = FALSE)
  icd:::icd9_parse_ahrq_ccs(single = FALSE, save_data = FALSE, offline = TRUE)
}
}
\keyword{internal}
\keyword{manip}
