% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hcc.R
\name{icd_comorbid_hcc}
\alias{icd_comorbid_hcc}
\alias{icd9_comorbid_hcc}
\alias{icd10_comorbid_hcc}
\title{Get Heirarchical Condition Codes (HCC)}
\usage{
icd_comorbid_hcc(x, icd_name = get_icd_name(x), ...)

icd9_comorbid_hcc(x, date_name = "date", visit_name = NULL,
  icd_name = NULL)

icd10_comorbid_hcc(x, date_name = "date", visit_name = NULL,
  icd_name = NULL)
}
\arguments{
\item{x}{data frame with columns for patient/visit ID, ICD code and date}

\item{icd_name}{The name of the column in the \code{data.frame} which
contains the ICD codes. This is a character vector of length one. If it is
\code{NULL}, \code{icd9} will attempt to guess the column name, looking for
progressively less likely possibilities until it matches a single column.
Failing this, it will take the first column in the data frame. Specifying
the column using this argument avoids the guesswork.}

\item{...}{arguments passed on to other functions}

\item{date_name}{the name of the column representing the date of each record.
Needed because each year there is a different ICD9/10 to CC mapping).
Default value is 'date'.}

\item{visit_name}{The name of the column in the data frame which contains the
patient or visit identifier. Typically this is the visit identifier, since
patients come leave and enter hospital with different ICD-9 codes. It is a
character vector of length one. If left empty, or \code{NULL}, then an
attempt is made to guess which field has the ID for the patient encounter
(not a patient ID, although this can of course be specified directly). The
guesses proceed until a single match is made. Data frames may be wide with
many matching fields, so to avoid false positives, anything but a single
match is rejected. If there are no successful guesses, and \code{visit_id}
was not specified, then the first column of the data frame is used.}
}
\description{
Applying CMS Hierarchical Condition Categories \code{icd_comorbid_hcc} works
differently from the rest of the comorbidity assignment functions. This is
because CMS publishes a detailed ICD to Condition Category mapping including
all child ICD codes. While these mappings were the same for 2007-2012, after
2013 there are annual versions, so date must be taken into consideration.
Also, there is a many:many linkage between ICD and Condition Categories (CC).
Once CCs are assigned, a series of hierarchy rules (which can also change
annually) are applied to create the HCCs.
}
\section{Functions}{
\itemize{
\item \code{icd9_comorbid_hcc}: Get HCCs from a data frame of ICD-9 codes

\item \code{icd10_comorbid_hcc}: Get HCCs from a data frame of ICD-10 codes
}}

