% Generated by roxygen2 (4.0.2): do not edit by hand
\name{decisionDST}
\alias{decisionDST}
\title{Decision Rules}
\usage{
decisionDST(mass, criterion, r = 0.5)
}
\arguments{
\item{mass}{The matrix containing the masses. Each column represents a piece of mass.}

\item{criterion}{The decision baseline:

    criterion=1 maximum of the plausibility

        criterion=2 maximum of the credibility

        criterion=3 maximum of the credibility with rejection

        criterion=4 maximum of the pignistic probability

        criterion=5 Appriou criterion (decision onto \eqn{2^\Theta})}

\item{r}{The parameter in BayesianMass function. If criterion 5 is used, it should be given.
Otherwise it will be set to the default value 0.5.}
}
\value{
The decision vector. E.g., in classification problem, class labels.
}
\description{
Different rules for making decisions in the framework of belief functions
}
\examples{
m1=c(0,0.4, 0.1, 0.2, 0.2, 0, 0, 0.1);
m2=c(0,0.2, 0.3, 0.1, 0.1, 0, 0.2, 0.1);
m3=c(0.1,0.2, 0, 0.1, 0.1, 0.1, 0, 0.3);

m3d=discounting(m3,0.95);

M_comb_Smets=DST(cbind(m1,m2,m3d),1);
M_comb_PCR6=DST(cbind(m1,m2),8);

class_fusion=decisionDST(M_comb_Smets,1)
class_fusion=decisionDST(M_comb_PCR6,1)
class_fusion=decisionDST(M_comb_Smets,5,0.5)
class_fusion=decisionDST(cbind(M_comb_Smets,M_comb_PCR6),1)
}

