% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{as.mixeddata}
\alias{as.mixeddata}
\title{Convert a vector of values to IAI mixed data format}
\usage{
as.mixeddata(values, categorical_levels, ordinal_levels = c())
}
\arguments{
\item{values}{The vector of values to convert}

\item{categorical_levels}{The values in \code{values} to treat as categoric
levels}

\item{ordinal_levels}{(optional) The values in \code{values} to treat as
ordinal levels, in the order supplied}
}
\description{
Julia Equivalent:
\href{https://docs.interpretable.ai/v3.1.0/IAIBase/reference/#IAI.make_mixed_data}{\code{IAI.make_mixed_data}}
}
\examples{
\dontrun{
df <- iris
set.seed(1)
df$mixed <- rnorm(150)
df$mixed[1:5] <- NA  # Insert some missing values
df$mixed[6:10] <- "Not graded"
df$mixed <- iai::as.mixeddata(df$mixed, c("Not graded"))
}
}
