% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iaibase.R
\name{fit_transform}
\alias{fit_transform}
\title{fit_transform}
\usage{
fit_transform(lnr, X, ...)
}
\arguments{
\item{lnr}{The learner or grid to use for imputation}

\item{X}{The features of the data.}

\item{...}{Refer to the Julia documentation for available parameters.}
}
\description{
Fit an imputation model using the given features and impute the missing
values in these features
}
\details{
Similar to calling \code{fit} followed by \code{transform}

Julia Equivalent:
\href{https://docs.interpretable.ai/IAIBase/stable/reference/#IAI.fit_transform!}{\code{IAI.fit_transform!}}
}
\examples{
\donttest{
X <- iris
X[1, 1] <- NA
iai::iai_setup()
grid <- iai::grid_search(
    iai::imputation_learner(),
    method = c("opt_knn", "opt_tree"),
)
iai::fit_transform(grid, X)
}
}
