% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preindexplot.R
\name{preindexplot}
\alias{preindexplot}
\title{Plot Estimations of Storm Activity Preindex}
\usage{
preindexplot(x, Title = NULL, start = NULL, end = NULL,
  n.station = NULL, graphs.per.page = 2, station.names = NULL, ...)
}
\arguments{
\item{x}{estimation of preindex from \code{SAIndex}}

\item{Title}{title of preindexplot}

\item{start}{start date of records for magnetic activities. See examples}

\item{end}{end date of records for magnetic activities. See examples}

\item{n.station}{number of stations}

\item{graphs.per.page}{how many graphs combined in one plot page. Default number is 2}

\item{station.names}{NULL (indicating no station names) or a vector strings for station names}

\item{...}{additional arguments.}
}
\description{
This function is used to visualize the preindex estimation for each station.
Users can specify the number of graphs per page, the default is set to 2 graphs per page.
}
\details{
This function is used to visualize the preindex. The function plots the preindex estimation from \code{SAIndex}. See example below.
}
\examples{
\dontrun{
## data sets.
data(record)
## Colatitude and longitude of geomagnetic observatories.
coord=matrix(c(124.43, 19.23, 53.77,140.18,68.68,202.00,71.89,293.85),nrow=2,ncol=4)


## estimation of one iWISA and one preindex for each stations.
data<- SAIndex(record, coord, wf="la8")

## generate datetime for one week period
start.date="2001-3-1"
end.date="2001-4-30"

preindexplot(data, Title="Preindex of stations", start = start.date,end=end.date,
n.station=4, graphs.per.page=2, station.names=c("HER","KAK","HON","SJG"))
}
}
\author{
Inga Maslova, Wen Xiao
}
\seealso{
\code{\link{SAIndex}}
}
\keyword{Preindexplot}

