% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta.spls.R
\name{meta.spls}
\alias{meta.spls}
\title{Meta-analytic sparse partial least squares method in integrative study}
\usage{
meta.spls(x, y, L, mu1, eps = 1e-04, kappa = 0.05, scale.x = TRUE,
  scale.y = TRUE, maxstep = 50, trace = FALSE)
}
\arguments{
\item{x}{list of data matrices, L datasets of explanatory variables.}

\item{y}{list of data matrices, L datasets of dependent variables.}

\item{L}{numeric, number of datasets.}

\item{mu1}{numeric, sparsity penalty parameter.}

\item{eps}{numeric, the threshold at which the algorithm terminates.}

\item{kappa}{numeric, 0 < kappa < 0.5 and the parameter reduces the effect of the concave part of objective function.}

\item{scale.x}{character, "TRUE" or "FALSE", whether or not to scale the variables x. The default is TRUE.}

\item{scale.y}{character, "TRUE" or "FALSE", whether or not to scale the variables y. The default is TRUE.}

\item{maxstep}{numeric, maximum iteration steps. The default value is 50.}

\item{trace}{character, "TRUE" or "FALSE". If TRUE, prints out its screening results of variables.}
}
\value{
A 'meta.spls' object that contains the list of the following items.
\itemize{
\item{x:}{ list of data matrices, L datasets of explanatory variables with centered columns. If scale.x is TRUE, the columns of L datasets are standardized to have mean 0 and standard deviation 1.}
\item{y:}{ list of data matrices, L datasets of dependent variables with centered columns. If scale.y is TRUE, the columns of L datasets are standardized to have mean 0 and standard deviation 1.}
\item{betahat:}{ the estimated regression coefficients.}
\item{loading:}{ the estimated first direction vector.}
\item{variable:}{ the screening results of variables x.}
\item{meanx:}{ list of numeric vectors, column mean of the original datasets x.}
\item{normx:}{ list of numeric vectors, column standard deviation of the original datasets x.}
\item{meany:}{ list of numeric vectors, column mean of the original datasets y.}
\item{normy:}{ list of numeric vectors, column standard deviation of the original datasets y.}
}
}
\description{
This function provides penalty-based sparse canonical correlation meta-analytic method to handle the multiple datasets with high dimensions generated under similar protocols, which is based on the principle of maximizing the summary statistics.
}
\examples{
library(iSFun)
data("simData.pls")
x <- simData.pls$x
y <- simData.pls$y
L <- length(x)

res <- meta.spls(x = x, y = y, L = L, mu1 = 0.03, trace = TRUE)
}
\seealso{
See Also as \code{\link{ispls}}.
}
