% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ispls.R
\name{ispls}
\alias{ispls}
\title{Integrative sparse partial least squares}
\usage{
ispls(x, y, L, mu1, mu2, eps = 1e-04, kappa = 0.05,
  pen1 = "homogeneity", pen2 = "magnitude", scale.x = TRUE,
  scale.y = TRUE, maxstep = 50, trace = FALSE, draw = FALSE)
}
\arguments{
\item{x}{list of data matrices, L datasets of explanatory variables.}

\item{y}{list of data matrices, L datasets of dependent variables.}

\item{L}{numeric, number of datasets.}

\item{mu1}{numeric, sparsity penalty parameter.}

\item{mu2}{numeric, contrasted penalty parameter.}

\item{eps}{numeric, the threshold at which the algorithm terminates.}

\item{kappa}{numeric, 0 < kappa < 0.5 and the parameter reduces the effect of the concave part of objective function.}

\item{pen1}{character, "homogeneity" or "heterogeneity" type of the sparsity structure. If not specified, the default is homogeneity.}

\item{pen2}{character, "magnitude" or "sign" based contrasted penalty. If not specified, the default is magnitude.}

\item{scale.x}{character, "TRUE" or "FALSE", whether or not to scale the variables x. The default is TRUE.}

\item{scale.y}{character, "TRUE" or "FALSE", whether or not to scale the variables y. The default is TRUE.}

\item{maxstep}{numeric, maximum iteration steps. The default value is 50.}

\item{trace}{character, "TRUE" or "FALSE". If TRUE, prints out its screening results of variables.}

\item{draw}{character, "TRUE" or "FALSE". If TRUE, plot the convergence path of loadings.}
}
\value{
An 'ispls' object that contains the list of the following items.
\itemize{
\item{x:}{ list of data matrices, L datasets of explanatory variables with centered columns. If scale.x is TRUE, the columns of L datasets are standardized to have mean 0 and standard deviation 1.}
\item{y:}{ list of data matrices, L datasets of dependent variables with centered columns. If scale.y is TRUE, the columns of L datasets are standardized to have mean 0 and standard deviation 1.}
\item{betahat:}{ the estimated regression coefficients.}
\item{loading:}{ the estimated first direction vector.}
\item{variable:}{ the screening results of variables x.}
\item{meanx:}{ list of numeric vectors, column mean of the original datasets x.}
\item{normx:}{ list of numeric vectors, column standard deviation of the original datasets x.}
\item{meany:}{ list of numeric vectors, column mean of the original datasets y.}
\item{normy:}{ list of numeric vectors, column standard deviation of the original datasets y.}
}
}
\description{
This function provides a penalty-based integrative sparse partial least squares method to handle the multiple datasets with high dimensions generated under similar protocols, which consists of two built-in penalty items for selecting the important variables for users to choose, and two contrasted penalty functions for eliminating the diffierence (magnitude or sign) between estimators within each group.
}
\examples{
# Load a list with 3 data sets
library(iSFun)
data("simData.pls")
x <- simData.pls$x
y <- simData.pls$y
L <- length(x)

prev_pls <- preview.pls(x, y, L, scale.x = TRUE, scale.y = TRUE)
res_homo_m <- ispls(x = x, y = y, L = L, mu1 = 0.05, mu2 = 0.25,
                    eps = 5e-2, trace = TRUE, draw = TRUE)

\donttest{
res_homo_s <- ispls(x = x, y = y, L = L, mu1 = 0.05, mu2 = 0.25,
                    eps = 5e-2, kappa = 0.05, pen1 = "homogeneity",
                    pen2 = "sign", scale.x = TRUE, scale.y = TRUE,
                    maxstep = 50, trace = FALSE, draw = FALSE)

res_hete_m <- ispls(x = x, y = y, L = L, mu1 = 0.05, mu2 = 0.25,
                    eps = 5e-2, kappa = 0.05, pen1 = "heterogeneity",
                    pen2 = "magnitude", scale.x = TRUE, scale.y = TRUE,
                    maxstep = 50, trace = FALSE, draw = FALSE)

res_hete_s <- ispls(x = x, y = y, L = L, mu1 = 0.05, mu2 = 0.25,
                    eps = 5e-2, kappa = 0.05, pen1 = "heterogeneity",
                    pen2 = "sign", scale.x = TRUE, scale.y = TRUE,
                    maxstep = 50, trace = FALSE, draw = FALSE)
}
}
\references{
\itemize{
\item{Liang W, Ma S, Zhang Q, et al. Integrative sparse partial least squares[J]. Statistics in Medicine, 2021, 40(9): 2239-2256.}
}
}
\seealso{
See Also as \code{\link{preview.pls}}, \code{\link{ispca}}, \code{\link{iscca}}.
}
