% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_extract_pngs.R
\name{ifcb_extract_pngs}
\alias{ifcb_extract_pngs}
\title{Extract Images from IFCB ROI File}
\usage{
ifcb_extract_pngs(
  roi_file,
  out_folder = dirname(roi_file),
  ROInumbers = NULL,
  taxaname = NULL,
  gamma = 1,
  verbose = TRUE,
  overwrite = FALSE
)
}
\arguments{
\item{roi_file}{A character string specifying the path to the .roi file.}

\item{out_folder}{A character string specifying the directory where the PNG images will be saved. Defaults to the directory of the ROI file.}

\item{ROInumbers}{An optional numeric vector specifying the ROI numbers to extract. If NULL, all ROIs with valid dimensions are extracted.}

\item{taxaname}{An optional character string specifying the taxa name for organizing images into subdirectories. Defaults to NULL.}

\item{gamma}{A numeric value for gamma correction applied to the image. Default is 1 (no correction). Values <1 increase contrast in dark regions, while values >1 decrease contrast.}

\item{verbose}{A logical value indicating whether to print progress messages. Default is TRUE.}

\item{overwrite}{A logical value indicating whether to overwrite existing PNG files. Default is FALSE.}
}
\value{
This function is called for its side effects: it writes PNG images to a directory.
}
\description{
This function reads an IFCB (.roi) file and its corresponding .adc file, extracts regions of interest (ROIs),
and saves each ROI as a PNG image in a specified directory. Optionally, you can specify ROI numbers
to extract, useful for specific ROIs from manual or automatic classification results.
}
\examples{
\dontrun{
# Convert ROI file to PNG images
ifcb_extract_pngs("path/to/your_roi_file.roi")

# Extract specific ROI numbers from ROI file
ifcb_extract_pngs("path/to/your_roi_file.roi", "output_directory", ROInumbers = c(1, 2, 3))
}
}
\seealso{
\code{\link{ifcb_extract_classified_images}} for extracting ROIs from automatic classification.

\code{\link{ifcb_extract_annotated_images}} for extracting ROIs from manual annotation.
}
