/*
 * Decompiled with CFR 0.152.
 */
package mrmc.core;

import java.text.DecimalFormat;

public class Matrix {
    public static double[] copy(double[] m) {
        double[] result = new double[m.length];
        int i = 0;
        while (i < m.length) {
            result[i] = m[i];
            ++i;
        }
        return result;
    }

    public static double[][] copy(double[][] m) {
        double[][] result = new double[m.length][m[0].length];
        int i = 0;
        while (i < m.length) {
            int j = 0;
            while (j < m[i].length) {
                result[i][j] = m[i][j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[] scale(double[] m1, double s) {
        double[] result = new double[m1.length];
        int i = 0;
        while (i < m1.length) {
            result[i] = m1[i] * s;
            ++i;
        }
        return result;
    }

    public static double[][] scale(double[][] m, double s) {
        double[][] result = new double[m.length][m[0].length];
        int i = 0;
        while (i < m.length) {
            int j = 0;
            while (j < m[i].length) {
                result[i][j] = m[i][j] * s;
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[] add(double[] m1, double[] m2) {
        double[] result = new double[m1.length];
        int i = 0;
        while (i < m1.length) {
            result[i] = m1[i] + m2[i];
            ++i;
        }
        return result;
    }

    public static double[][] add(double[][] m1, double[][] m2) {
        double[][] result = new double[m1.length][m1[0].length];
        int i = 0;
        while (i < m1.length) {
            int j = 0;
            while (j < m1[0].length) {
                result[i][j] = m1[i][j] + m2[i][j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[] squareTerms(double[] m1) {
        double[] result = new double[m1.length];
        int i = 0;
        while (i < m1.length) {
            result[i] = m1[i] * m1[i];
            ++i;
        }
        return result;
    }

    public static double[][] squareTerms(double[][] m) {
        double[][] result = new double[m.length][m[0].length];
        int i = 0;
        while (i < m.length) {
            int j = 0;
            while (j < m[i].length) {
                result[i][j] = m[i][j] * m[i][j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static int total(int[][] m) {
        int rows = m.length;
        int cols = m[0].length;
        int T = 0;
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                T += m[i][j];
                ++j;
            }
            ++i;
        }
        return T;
    }

    public static double total(double[][] m) {
        int rows = m.length;
        int cols = m[0].length;
        double T = 0.0;
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                T += m[i][j];
                ++j;
            }
            ++i;
        }
        return T;
    }

    public static double total(double[] m) {
        int rows = m.length;
        double T = 0.0;
        int i = 0;
        while (i < rows) {
            T += m[i];
            ++i;
        }
        return T;
    }

    public static double[][] multiply(double[][] m1, double[][] m2) {
        int j;
        int m1rows = m1.length;
        int m1cols = m1[0].length;
        int m2rows = m2.length;
        int m2cols = m2[0].length;
        if (m1cols != m2rows) {
            throw new IllegalArgumentException("matrices don't match: " + m1cols + " != " + m2rows);
        }
        double[][] result = new double[m1rows][m2cols];
        int i = 0;
        while (i < m1rows) {
            j = 0;
            while (j < m2cols) {
                result[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < m1rows) {
            j = 0;
            while (j < m2cols) {
                int k = 0;
                while (k < m1cols) {
                    double[] dArray = result[i];
                    int n = j;
                    dArray[n] = dArray[n] + m1[i][k] * m2[k][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[] multiply(double[][] m1, double[] m2) {
        int m1rows = m1.length;
        int m1cols = m1[0].length;
        int m2rows = m2.length;
        if (m1cols != m2rows) {
            throw new IllegalArgumentException("matrices don't match: " + m1cols + " != " + m2rows);
        }
        double[] result = new double[m1rows];
        int i = 0;
        while (i < m1rows) {
            result[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < m1rows) {
            int k = 0;
            while (k < m1cols) {
                int n = i;
                result[n] = result[n] + m1[i][k] * m2[k];
                ++k;
            }
            ++i;
        }
        return result;
    }

    public static int[][] multiply(int[][] m1, int[][] m2) {
        int j;
        int m1rows = m1.length;
        int m1cols = m1[0].length;
        int m2rows = m2.length;
        int m2cols = m2[0].length;
        if (m1cols != m2rows) {
            throw new IllegalArgumentException("matrices don't match: " + m1cols + " != " + m2rows);
        }
        int[][] result = new int[m1rows][m2cols];
        int i = 0;
        while (i < m1rows) {
            j = 0;
            while (j < m2cols) {
                result[i][j] = 0;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < m1rows) {
            j = 0;
            while (j < m2cols) {
                int k = 0;
                while (k < m1cols) {
                    int[] nArray = result[i];
                    int n = j;
                    nArray[n] = nArray[n] + m1[i][k] * m2[k][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[] dotProduct(double[] m1, double[] m2) {
        double[] result = new double[m1.length];
        if (m1.length != m2.length) {
            throw new IllegalArgumentException("vector length don't match : " + m1.length + " != " + m2.length);
        }
        int i = 0;
        while (i < m1.length) {
            result[i] = m1[i] * m2[i];
            ++i;
        }
        return result;
    }

    public static double[][] matrixTranspose(double[][] m) {
        double[][] result = new double[m[0].length][m.length];
        int i = 0;
        while (i < m.length) {
            int j = 0;
            while (j < m[0].length) {
                result[j][i] = m[i][j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static int[][] matrixTranspose(int[][] m) {
        int[][] result = new int[m[0].length][m.length];
        int i = 0;
        while (i < m.length) {
            int j = 0;
            while (j < m[0].length) {
                result[j][i] = m[i][j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static void printVector(double[] m) {
        DecimalFormat df = new DecimalFormat("0.###E0");
        String temp = "";
        int i = 0;
        while (i < m.length) {
            int totalWidth = 14;
            int numWidth = df.format(m[i]).length();
            int numSpaces = totalWidth - numWidth;
            temp = String.valueOf(temp) + df.format(m[i]);
            int n = 0;
            while (n < numSpaces) {
                temp = String.valueOf(temp) + " ";
                ++n;
            }
            ++i;
        }
        temp = String.valueOf(temp) + "\n";
        System.out.print(temp);
    }

    public static void printMatrix(double[][] m) {
        int col = m[0].length;
        int row = m.length;
        DecimalFormat df = new DecimalFormat("0.###E0");
        int i = 0;
        while (i < row) {
            String temp = "";
            int j = 0;
            while (j < col) {
                int totalWidth = 14;
                int numWidth = df.format(m[i][j]).length();
                int numSpaces = totalWidth - numWidth;
                temp = String.valueOf(temp) + df.format(m[i][j]);
                int n = 0;
                while (n < numSpaces) {
                    temp = String.valueOf(temp) + " ";
                    ++n;
                }
                ++j;
            }
            temp = String.valueOf(temp) + "\n";
            System.out.print(temp);
            ++i;
        }
    }

    public static void printMatrix(int[][] m) {
        int col = m[0].length;
        int row = m.length;
        int i = 0;
        while (i < row) {
            String temp = "";
            int j = 0;
            while (j < col) {
                temp = String.valueOf(temp) + m[i][j] + " ";
                ++j;
            }
            temp = String.valueOf(temp) + "\n";
            System.out.print(temp);
            ++i;
        }
    }

    public static double[] get1Dimension(int start, double[][][] m, String d1, String d2, String d3) {
        double[] result;
        if (d1.equals("*")) {
            result = new double[m.length - start];
            int dim2 = Integer.parseInt(d2);
            int dim3 = Integer.parseInt(d3);
            int i = 0;
            while (i < m.length - start) {
                result[i] = m[i + start][dim2][dim3];
                ++i;
            }
        } else if (d2.equals("*")) {
            result = new double[m[0].length - start];
            int dim1 = Integer.parseInt(d1);
            int dim3 = Integer.parseInt(d3);
            int i = 0;
            while (i < m[0].length - start) {
                result[i] = m[dim1][i + start][dim3];
                ++i;
            }
        } else if (d3.equals("*")) {
            result = new double[m[0][0].length - start];
            int dim1 = Integer.parseInt(d1);
            int dim2 = Integer.parseInt(d2);
            int i = 0;
            while (i < m[0][0].length - start) {
                result[i] = m[dim1][dim2][i + start];
                ++i;
            }
        } else {
            throw new NumberFormatException("Must indicate a dimension to iterate");
        }
        return result;
    }

    public static int[][] extractFirstDimension(int[][][] m, int d2, int d3) {
        int[][] result = new int[m.length][1];
        int i = 0;
        while (i < m.length) {
            result[i][0] = m[i][d2][d3];
            ++i;
        }
        return result;
    }

    public static double[][] extractFirstDimension(double[][][] m, int d2, int d3) {
        double[][] result = new double[m.length][1];
        int i = 0;
        while (i < m.length) {
            result[i][0] = m[i][d2][d3];
            ++i;
        }
        return result;
    }

    public static double[][] linearTrans(double[][] m, double k, double d) {
        double[][] result = new double[m.length][m[0].length];
        int i = 0;
        while (i < m.length) {
            int j = 0;
            while (j < m[0].length) {
                result[i][j] = m[i][j] * k + d;
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[] linearTrans(double[] m, double k, double d) {
        double[] result = new double[m.length];
        int i = 0;
        while (i < m.length) {
            result[i] = m[i] * k + d;
            ++i;
        }
        return result;
    }

    public static double[][] linearTrans(int[][] m, double k, double d) {
        double[][] result = new double[m.length][m[0].length];
        int i = 0;
        while (i < m.length) {
            int j = 0;
            while (j < m[0].length) {
                result[i][j] = (double)m[i][j] * k + d;
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[][] subtract(double[][] m1, double[][] m2) {
        double[][] result = new double[m1.length][m1[0].length];
        int i = 0;
        while (i < m1.length) {
            int j = 0;
            while (j < m1[0].length) {
                result[i][j] = m1[i][j] - m2[i][j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[][] elementMultiply(double[][] m1, double[][] m2) {
        double[][] result = new double[m1.length][m1[0].length];
        int i = 0;
        while (i < m1.length) {
            int j = 0;
            while (j < m1[0].length) {
                result[i][j] = m1[i][j] * m2[i][j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static int[][] elementMultiply(int[][] m1, int[][] m2) {
        int[][] result = new int[m1.length][m1[0].length];
        int i = 0;
        while (i < m1.length) {
            int j = 0;
            while (j < m1[0].length) {
                result[i][j] = m1[i][j] * m2[i][j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[] elementMultiply(double[] m1, double[] m2) {
        double[] result = new double[m1.length];
        int i = 0;
        while (i < m1.length) {
            result[i] = m1[i] * m2[i];
            ++i;
        }
        return result;
    }

    public static double[] rowSum(double[][] m) {
        double[] result = new double[m.length];
        int i = 0;
        while (i < m.length) {
            result[i] = 0.0;
            int j = 0;
            while (j < m[0].length) {
                result[i] = result[i] + m[i][j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[] colSum(double[][] m) {
        double[] result = new double[m[0].length];
        int j = 0;
        while (j < m[0].length) {
            result[j] = 0.0;
            int i = 0;
            while (i < m.length) {
                result[j] = result[j] + m[i][j];
                ++i;
            }
            ++j;
        }
        return result;
    }

    public static double[] setZero(int X) {
        double[] result = new double[X];
        int i = 0;
        while (i < X) {
            result[i] = 0.0;
            ++i;
        }
        return result;
    }

    public static double[][] setZero(int X, int Y) {
        double[][] result = new double[X][Y];
        int i = 0;
        while (i < X) {
            int j = 0;
            while (j < Y) {
                result[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double min(double[][] m) {
        double x = m[0][0];
        int i = 0;
        while (i < m.length) {
            int j = 0;
            while (j < m[0].length) {
                if (m[i][j] < x) {
                    x = m[i][j];
                }
                ++j;
            }
            ++i;
        }
        return x;
    }
}

