/*
 * Decompiled with CFR 0.152.
 */
package mrmc.chart;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.SymbolAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RefineryUtilities;

public class StudyDesignPlot
extends JFrame {
    private static final long serialVersionUID = 1L;
    private String[][] readerrelation;
    private String[][] caserelation;
    private String filenamewithpath;
    private String filename;

    public StudyDesignPlot(String title, String mod, String xaxis, String yaxis, TreeMap<String, String[][]> StudyDesignData, String filePathAndName, String fileName) {
        super(title);
        this.filenamewithpath = filePathAndName;
        this.filenamewithpath = this.filenamewithpath.substring(0, this.filenamewithpath.lastIndexOf("."));
        this.filename = fileName.substring(0, fileName.lastIndexOf("."));
        String[][] data = StudyDesignData.get("data");
        this.readerrelation = StudyDesignData.get("readerrelation");
        this.caserelation = StudyDesignData.get("caserelation");
        String[] label = new String[data.length];
        XYDataset dataset = this.createDataset(data);
        int i = 0;
        while (i < data.length) {
            label[i] = data[i][0];
            ++i;
        }
        JFreeChart chart = this.createChart(dataset, title, xaxis, yaxis, label);
        ChartPanel chartPanel = new ChartPanel(chart);
        JButton indexrelation = new JButton("Show relationship: Index & ID");
        indexrelation.addActionListener(new indexrelationButtonListener());
        chartPanel.setPreferredSize(new Dimension(500, 270));
        JPanel showrelation = new JPanel();
        showrelation.add(indexrelation);
        this.add(chartPanel);
        this.add((Component)showrelation, "Last");
    }

    private XYDataset createDataset(String[][] data) {
        int nBlack = 0;
        int nWhite = 0;
        int i = 0;
        while (i < data.length) {
            int j = 1;
            while (j < data[i].length) {
                if (data[i][j] == "true") {
                    ++nBlack;
                } else {
                    ++nWhite;
                }
                ++j;
            }
            ++i;
        }
        double[][] trueVals = new double[2][nBlack];
        double[][] falseVals = new double[2][nWhite];
        DefaultXYDataset dataset = new DefaultXYDataset();
        int tCount = 0;
        int fCount = 0;
        int i2 = 0;
        while (i2 < data.length) {
            int j = 1;
            while (j < data[i2].length) {
                if (data[i2][j] == "true") {
                    trueVals[0][tCount] = j;
                    trueVals[1][tCount] = i2;
                    ++tCount;
                } else {
                    falseVals[0][fCount] = j;
                    falseVals[1][fCount] = i2;
                    ++fCount;
                }
                ++j;
            }
            ++i2;
        }
        dataset.addSeries((Comparable)((Object)"Missing"), falseVals);
        dataset.addSeries((Comparable)((Object)"Present"), trueVals);
        return dataset;
    }

    private JFreeChart createChart(XYDataset dataset, String title, String xaxis, String yaxis, String[] label) {
        JFreeChart chart = ChartFactory.createScatterPlot(title, xaxis, yaxis, dataset, PlotOrientation.VERTICAL, true, true, false);
        XYPlot xyplot = (XYPlot)chart.getPlot();
        SymbolAxis rangeAxis1 = new SymbolAxis(yaxis, label);
        rangeAxis1.setTickUnit(new NumberTickUnit(1.0));
        rangeAxis1.setRange(-0.5, (double)label.length - 0.5);
        xyplot.setRangeAxis(rangeAxis1);
        XYItemRenderer renderer = xyplot.getRenderer();
        Rectangle square = new Rectangle(5, 5);
        renderer.setSeriesShape(0, square);
        renderer.setSeriesShape(1, square);
        renderer.setSeriesPaint(0, Color.white);
        renderer.setSeriesPaint(1, Color.black);
        return chart;
    }

    class caseexportButtonListener
    implements ActionListener {
        caseexportButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String caseexport = "CaseIndex,CaseID\r\n";
            int i = 0;
            while (i < StudyDesignPlot.this.caserelation.length) {
                caseexport = String.valueOf(caseexport) + StudyDesignPlot.this.caserelation[i][0] + "," + StudyDesignPlot.this.caserelation[i][1] + "\r\n";
                ++i;
            }
            SimpleDateFormat dateForm = new SimpleDateFormat("yyyyMMddHHmm");
            Date currDate = new Date();
            String fileTime = dateForm.format(currDate);
            String caserelationwithpath = String.valueOf(StudyDesignPlot.this.filenamewithpath) + "caseIndextoID" + fileTime + ".csv";
            try {
                FileWriter fw = new FileWriter(caserelationwithpath);
                BufferedWriter bw = new BufferedWriter(fw);
                bw.write(caseexport);
                bw.close();
                JFrame frame = new JFrame();
                JOptionPane.showMessageDialog(frame, "Case Index to case has been succeed export to input file directory!\nFilename=" + StudyDesignPlot.this.filename + "caseIndextoID" + fileTime + ".csv", "Exported", 1);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    class indexrelationButtonListener
    implements ActionListener {
        indexrelationButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFrame JFramereader = new JFrame("Reader Index relationship");
            RefineryUtilities.centerFrameOnScreen(JFramereader);
            JFramereader.setDefaultCloseOperation(2);
            Object[] readercolNames = new Object[]{"ReaderIndex", "ReaderID"};
            JTable tablereader = new JTable(StudyDesignPlot.this.readerrelation, readercolNames);
            JScrollPane scrollPanereader = new JScrollPane(tablereader);
            RefineryUtilities.centerFrameOnScreen(JFramereader);
            JButton readerexport = new JButton("Export");
            readerexport.addActionListener(new readerexportButtonListener());
            JFramereader.add((Component)scrollPanereader, "Center");
            JFramereader.add((Component)readerexport, "Last");
            JFramereader.setSize(600, 300);
            JFramereader.setVisible(true);
            JFrame JFramecase = new JFrame("Case Index relationship");
            RefineryUtilities.centerFrameOnScreen(JFramecase);
            JFramecase.setDefaultCloseOperation(2);
            Object[] casecolNames = new Object[]{"CaseIndex", "CaseID"};
            JTable tablecase = new JTable(StudyDesignPlot.this.caserelation, casecolNames);
            JScrollPane scrollPanecase = new JScrollPane(tablecase);
            RefineryUtilities.centerFrameOnScreen(JFramereader);
            JButton caseexport = new JButton("Export");
            caseexport.addActionListener(new caseexportButtonListener());
            JFramecase.add((Component)scrollPanecase, "Center");
            JFramecase.add((Component)caseexport, "Last");
            JFramecase.setSize(600, 300);
            JFramecase.setVisible(true);
            RefineryUtilities.positionFrameOnScreen(JFramecase, 0.6, 0.6);
        }
    }

    class readerexportButtonListener
    implements ActionListener {
        readerexportButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String readerexport = "ReaderIndex,ReaderID\r\n";
            int i = 0;
            while (i < StudyDesignPlot.this.readerrelation.length) {
                readerexport = String.valueOf(readerexport) + StudyDesignPlot.this.readerrelation[i][0] + "," + StudyDesignPlot.this.readerrelation[i][1] + "\r\n";
                ++i;
            }
            SimpleDateFormat dateForm = new SimpleDateFormat("yyyyMMddHHmm");
            Date currDate = new Date();
            String fileTime = dateForm.format(currDate);
            String readerrelationwithpath = String.valueOf(StudyDesignPlot.this.filenamewithpath) + "readerIndextoID" + fileTime + ".csv";
            try {
                FileWriter fw = new FileWriter(readerrelationwithpath);
                BufferedWriter bw = new BufferedWriter(fw);
                bw.write(readerexport);
                bw.close();
                JFrame frame = new JFrame();
                JOptionPane.showMessageDialog(frame, "Reader Index to reader ID has been succeed export to input file directory!\nFilename=" + StudyDesignPlot.this.filename + "readerIndextoID" + fileTime + ".csv", "Exported", 1);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }
}

