/*
 * Decompiled with CFR 0.152.
 */
package mrmc.core;

import mrmc.core.DBRecord;
import mrmc.core.InputFile;
import mrmc.core.Matrix;
import mrmc.gui.SizePanel;

public class CovMRMC {
    InputFile InputFileStat;
    DBRecord DBRecordStat;
    DBRecord DBRecordSize;
    SizePanel SizePanel1;
    public double[] momentsAA = new double[9];
    public double[] momentsBB = new double[9];
    public double[] momentsAB = new double[9];
    public double[] momentsBiasedAA = new double[9];
    public double[] momentsBiasedBB = new double[9];
    public double[] momentsBiasedAB = new double[9];
    public double[][] readerMomentsAA;
    public double[][] readerMomentsBB;
    public double[][] readerMomentsAB;
    public double[][][] readerMomentsAACov;
    public double[][][] readerMomentsBBCov;
    public double[][][] readerMomentsABCov;
    public double[][] readerMomentsBiasedAA;
    public double[][] readerMomentsBiasedBB;
    public double[][] readerMomentsBiasedAB;
    public double[][][] readerMomentsBiasedAACov;
    public double[][][] readerMomentsBiasedBBCov;
    public double[][][] readerMomentsBiasedABCov;
    public double[] coefficientsAA = new double[9];
    public double[] coefficientsBB = new double[9];
    public double[] coefficientsAB = new double[9];
    public double[][] readerCoefficientsAA;
    public double[][] readerCoefficientsBB;
    public double[][] readerCoefficientsAB;
    public double[][][] readerCoefficientsAACov;
    public double[][][] readerCoefficientsBBCov;
    public double[][][] readerCoefficientsABCov;
    public double[][][] t0_modAB;
    public double[][][] t1_modAB;
    public double[][][] t0_modAA;
    public double[][][] t1_modAA;
    public double[][][] t0_modBB;
    public double[][][] t1_modBB;
    public int[][][] d0_modAB;
    public int[][][] d1_modAB;
    public int[][][] d0_modAA;
    public int[][][] d1_modAA;
    public int[][][] d0_modBB;
    public int[][][] d1_modBB;
    public int[][] N0perReader;
    public int[][] N1perReader;
    public int totalscoredA;
    public int totalscoredB;
    public int totalscoredAB;
    private double[] AUCsReaderAvg;
    private double[][] AUCs;
    private long Nnormal;
    private long Ndisease;
    private long Nreader;
    boolean fullyCrossedA = true;
    boolean fullyCrossedB = true;
    boolean fullyCrossedAB = true;

    public CovMRMC(InputFile InputFileStatTemp, DBRecord DBRecordStatTemp) {
        this.InputFileStat = InputFileStatTemp;
        this.DBRecordStat = DBRecordStatTemp;
        this.Nreader = this.InputFileStat.Nreader;
        this.Nnormal = this.InputFileStat.Nnormal;
        this.Ndisease = this.InputFileStat.Ndisease;
        this.DBRecordStat.Nnormal = this.Nnormal;
        this.DBRecordStat.Ndisease = this.Ndisease;
        this.DBRecordStat.Nreader = this.Nreader;
        this.readerMomentsAA = new double[(int)this.Nreader][5];
        this.readerMomentsBiasedAA = new double[(int)this.Nreader][5];
        this.readerMomentsBB = new double[(int)this.Nreader][5];
        this.readerMomentsBiasedBB = new double[(int)this.Nreader][5];
        this.readerMomentsAB = new double[(int)this.Nreader][5];
        this.readerMomentsBiasedAB = new double[(int)this.Nreader][5];
        this.readerMomentsAACov = new double[(int)this.Nreader][(int)this.Nreader][5];
        this.readerMomentsBiasedAACov = new double[(int)this.Nreader][(int)this.Nreader][5];
        this.readerMomentsBBCov = new double[(int)this.Nreader][(int)this.Nreader][5];
        this.readerMomentsBiasedBBCov = new double[(int)this.Nreader][(int)this.Nreader][5];
        this.readerMomentsABCov = new double[(int)this.Nreader][(int)this.Nreader][5];
        this.readerMomentsBiasedABCov = new double[(int)this.Nreader][(int)this.Nreader][5];
        this.readerCoefficientsAA = new double[(int)this.Nreader][5];
        this.readerCoefficientsBB = new double[(int)this.Nreader][5];
        this.readerCoefficientsAB = new double[(int)this.Nreader][5];
        this.readerCoefficientsAACov = new double[(int)this.Nreader][(int)this.Nreader][5];
        this.readerCoefficientsBBCov = new double[(int)this.Nreader][(int)this.Nreader][5];
        this.readerCoefficientsABCov = new double[(int)this.Nreader][(int)this.Nreader][5];
        this.makeTMatrices();
        if (DBRecordStatTemp.selectedMod == 0) {
            this.doAUCcovUstatistics("AA");
        }
        if (DBRecordStatTemp.selectedMod == 1) {
            this.doAUCcovUstatistics("BB");
        }
        if (DBRecordStatTemp.selectedMod == 3) {
            this.doAUCcovUstatistics("AA");
            this.doAUCcovUstatistics("BB");
            this.doAUCcovUstatistics("AB");
        }
        this.DBRecordStat.AUCs = this.AUCs;
        this.DBRecordStat.AUCsReaderAvg = this.AUCsReaderAvg;
    }

    public CovMRMC(SizePanel SizePanelTemp) {
        this.SizePanel1 = SizePanelTemp;
        this.Nreader = Integer.parseInt(this.SizePanel1.NreaderJTextField.getText());
        this.Nnormal = Integer.parseInt(this.SizePanel1.NnormalJTextField.getText());
        this.Ndisease = Integer.parseInt(this.SizePanel1.NdiseaseJTextField.getText());
        this.makeDMatrices();
    }

    public CovMRMC(SizePanel SizePanelTemp, DBRecord DBRecordSizeTemp) {
        this.SizePanel1 = SizePanelTemp;
        this.DBRecordSize = DBRecordSizeTemp;
        this.Nreader = Integer.parseInt(this.SizePanel1.NreaderJTextField.getText());
        this.Nnormal = Integer.parseInt(this.SizePanel1.NnormalJTextField.getText());
        this.Ndisease = Integer.parseInt(this.SizePanel1.NdiseaseJTextField.getText());
        this.DBRecordSize.Nnormal = this.Nnormal;
        this.DBRecordSize.Ndisease = this.Ndisease;
        this.DBRecordSize.Nreader = this.Nreader;
        this.readerMomentsAA = new double[(int)this.Nreader][5];
        this.readerMomentsBiasedAA = new double[(int)this.Nreader][5];
        this.readerMomentsBB = new double[(int)this.Nreader][5];
        this.readerMomentsBiasedBB = new double[(int)this.Nreader][5];
        this.readerMomentsAB = new double[(int)this.Nreader][5];
        this.readerMomentsBiasedAB = new double[(int)this.Nreader][5];
        this.readerCoefficientsAA = new double[(int)this.Nreader][5];
        this.readerCoefficientsBB = new double[(int)this.Nreader][5];
        this.readerCoefficientsAB = new double[(int)this.Nreader][5];
        this.readerMomentsAACov = new double[(int)this.Nreader][(int)this.Nreader][5];
        this.readerMomentsBiasedAACov = new double[(int)this.Nreader][(int)this.Nreader][5];
        this.readerMomentsBBCov = new double[(int)this.Nreader][(int)this.Nreader][5];
        this.readerMomentsBiasedBBCov = new double[(int)this.Nreader][(int)this.Nreader][5];
        this.readerMomentsABCov = new double[(int)this.Nreader][(int)this.Nreader][5];
        this.readerMomentsBiasedABCov = new double[(int)this.Nreader][(int)this.Nreader][5];
        this.readerCoefficientsAACov = new double[(int)this.Nreader][(int)this.Nreader][5];
        this.readerCoefficientsBBCov = new double[(int)this.Nreader][(int)this.Nreader][5];
        this.readerCoefficientsABCov = new double[(int)this.Nreader][(int)this.Nreader][5];
        this.makeDMatrices();
        if (this.DBRecordSize.selectedMod == 0) {
            this.doAUCcovUstatistics("AA");
        }
        if (this.DBRecordSize.selectedMod == 1) {
            this.doAUCcovUstatistics("BB");
        }
        if (this.DBRecordSize.selectedMod == 3) {
            this.doAUCcovUstatistics("AA");
            this.doAUCcovUstatistics("BB");
            this.doAUCcovUstatistics("AB");
        }
        this.DBRecordSize.AUCs = this.AUCs;
        this.DBRecordSize.AUCsReaderAvg = this.AUCsReaderAvg;
    }

    public void doAUCcovUstatistics(String flagModality) {
        this.AUCsReaderAvg = new double[3];
        this.AUCsReaderAvg[0] = -1.0;
        this.AUCsReaderAvg[1] = -1.0;
        this.AUCsReaderAvg[2] = -1.0;
        this.AUCs = new double[(int)this.Nreader][3];
        int i = 0;
        while ((long)i < this.Nreader) {
            this.AUCs[i][0] = -1.0;
            this.AUCs[i][1] = -1.0;
            this.AUCs[i][2] = -1.0;
            ++i;
        }
        double[] moments = new double[9];
        double[][] readerMoments = new double[(int)this.Nreader][5];
        double[][][] readerMomentsCov = new double[(int)this.Nreader][(int)this.Nreader][5];
        double[] momentsBiased = new double[9];
        double[][] readerMomentsBiased = new double[(int)this.Nreader][5];
        double[][][] readerMomentsBiasedCov = new double[(int)this.Nreader][(int)this.Nreader][5];
        double[] coefficients = new double[9];
        double[][] readerCoefficients = new double[(int)this.Nreader][5];
        double[][][] readerCoefficientsCov = new double[(int)this.Nreader][(int)this.Nreader][5];
        double[][][] t0 = this.t0_modAB;
        double[][][] t1 = this.t1_modAB;
        int[][][] d0 = this.d0_modAB;
        int[][][] d1 = this.d1_modAB;
        switch (flagModality) {
            case "AA": {
                t0 = this.t0_modAA;
                d0 = this.d0_modAA;
                t1 = this.t1_modAA;
                d1 = this.d1_modAA;
                break;
            }
            case "BB": {
                t0 = this.t0_modBB;
                d0 = this.d0_modBB;
                t1 = this.t1_modBB;
                d1 = this.d1_modBB;
            }
        }
        double aucA = 0.0;
        double aucB = 0.0;
        double[][] w = new double[(int)this.Nreader][2];
        int[] pairs = new int[3];
        double totalwada = 0.0;
        double totalwbdb = 0.0;
        double totalwbdbCov = 0.0;
        double[] readerTotalwada = new double[(int)this.Nreader];
        double[] readerTotalwbdb = new double[(int)this.Nreader];
        double[][] readerTotalwbdbCov = new double[(int)this.Nreader][(int)this.Nreader];
        double[] bnumer = new double[9];
        double[][] readerBnumer = new double[(int)this.Nreader][5];
        double[][][] readerBnumerCov = new double[(int)this.Nreader][(int)this.Nreader][5];
        double[][] wadasaSumr = new double[(int)this.Nnormal][(int)this.Ndisease];
        double[][] wbdbsbSumr = new double[(int)this.Nnormal][(int)this.Ndisease];
        double[] wadasaSumir = new double[(int)this.Ndisease];
        double[] wbdbsbSumir = new double[(int)this.Ndisease];
        double[] wadasaSumjr = new double[(int)this.Nnormal];
        double[] wbdbsbSumjr = new double[(int)this.Nnormal];
        double wadasaSumijr = 0.0;
        double wbdbsbSumijr = 0.0;
        double[] bdenom = new double[9];
        double[][] readerBdenom = new double[(int)this.Nreader][5];
        double[][][] readerBdenomCov = new double[(int)this.Nreader][(int)this.Nreader][5];
        double[][] wadaSumr = new double[(int)this.Nnormal][(int)this.Ndisease];
        double[][] wbdbSumr = new double[(int)this.Nnormal][(int)this.Ndisease];
        double[] wadaSumir = new double[(int)this.Ndisease];
        double[] wbdbSumir = new double[(int)this.Ndisease];
        double[] wadaSumjr = new double[(int)this.Nnormal];
        double[] wbdbSumjr = new double[(int)this.Nnormal];
        double wadaSumijr = 0.0;
        double wbdbSumijr = 0.0;
        int i2 = 0;
        while ((long)i2 < this.Nreader) {
            int j = 0;
            while (j < 2) {
                w[i2][j] = 1.0;
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < 3) {
            pairs[i2] = 0;
            ++i2;
        }
        int ir = 0;
        while ((long)ir < this.Nreader) {
            int[][] designA0 = Matrix.extractFirstDimension(d0, ir, 0);
            int[][] designA1 = Matrix.extractFirstDimension(d1, ir, 0);
            int[][] da = Matrix.multiply(designA0, Matrix.matrixTranspose(designA1));
            int totalda = Matrix.total(da);
            double wa = w[ir][0];
            double[][] t0A_ir = Matrix.extractFirstDimension(t0, ir, 0);
            double[][] t1A_ir = Matrix.extractFirstDimension(t1, ir, 0);
            double[][] ones_vect0 = Matrix.linearTrans(t0A_ir, 0.0, 1.0);
            double[][] ones_vect1 = Matrix.linearTrans(t1A_ir, 0.0, 1.0);
            double[][] sa0 = Matrix.multiply(t0A_ir, Matrix.matrixTranspose(ones_vect1));
            double[][] sa1 = Matrix.multiply(ones_vect0, Matrix.matrixTranspose(t1A_ir));
            double[][] sa = Matrix.subtract(sa1, sa0);
            int i3 = 0;
            while ((long)i3 < this.Nnormal) {
                int j = 0;
                while ((long)j < this.Ndisease) {
                    if (sa[i3][j] < 0.0) {
                        sa[i3][j] = 0.0;
                    } else if (sa[i3][j] == 0.0) {
                        sa[i3][j] = 0.5;
                    } else if (sa[i3][j] > 0.0) {
                        sa[i3][j] = 1.0;
                    }
                    ++j;
                }
                ++i3;
            }
            double[][] wada = Matrix.linearTrans(da, wa, 0.0);
            double[][] wadasa = Matrix.elementMultiply(wada, sa);
            int[][] designB0 = Matrix.extractFirstDimension(d0, ir, 1);
            int[][] designB1 = Matrix.extractFirstDimension(d1, ir, 1);
            int[][] db = Matrix.multiply(designB0, Matrix.matrixTranspose(designB1));
            int totaldb = Matrix.total(db);
            double wb = w[ir][1];
            double[][] t0B_ir = Matrix.extractFirstDimension(t0, ir, 1);
            double[][] t1B_ir = Matrix.extractFirstDimension(t1, ir, 1);
            double[][] sb0 = Matrix.multiply(t0B_ir, Matrix.matrixTranspose(ones_vect1));
            double[][] sb1 = Matrix.multiply(ones_vect0, Matrix.matrixTranspose(t1B_ir));
            double[][] sb = Matrix.subtract(sb1, sb0);
            int i4 = 0;
            while ((long)i4 < this.Nnormal) {
                int j = 0;
                while ((long)j < this.Ndisease) {
                    if (sb[i4][j] < 0.0) {
                        sb[i4][j] = 0.0;
                    } else if (sb[i4][j] == 0.0) {
                        sb[i4][j] = 0.5;
                    } else if (sb[i4][j] > 0.0) {
                        sb[i4][j] = 1.0;
                    }
                    ++j;
                }
                ++i4;
            }
            double[][] wbdb = Matrix.linearTrans(db, wb, 0.0);
            double[][] wbdbsb = Matrix.elementMultiply(wbdb, sb);
            pairs[0] = pairs[0] + totalda;
            pairs[1] = pairs[1] + totaldb;
            pairs[2] = pairs[2] + Matrix.total(Matrix.elementMultiply(da, db));
            double[] wada_sumi = Matrix.colSum(wada);
            double[] wbdb_sumi = Matrix.colSum(wbdb);
            double[] wadasa_sumi = Matrix.colSum(wadasa);
            double[] wbdbsb_sumi = Matrix.colSum(wbdbsb);
            double[] wada_sumj = Matrix.rowSum(wada);
            double[] wbdb_sumj = Matrix.rowSum(wbdb);
            double[] wadasa_sumj = Matrix.rowSum(wadasa);
            double[] wbdbsb_sumj = Matrix.rowSum(wbdbsb);
            double wada_sumij = Matrix.total(wada);
            double wbdb_sumij = Matrix.total(wbdb);
            double wadasa_sumij = Matrix.total(wadasa);
            double wbdbsb_sumij = Matrix.total(wbdbsb);
            bdenom[1] = bdenom[1] + Matrix.total(Matrix.elementMultiply(wada, wbdb));
            bdenom[2] = bdenom[2] + Matrix.total(Matrix.elementMultiply(wada_sumi, wbdb_sumi));
            bdenom[3] = bdenom[3] + Matrix.total(Matrix.elementMultiply(wada_sumj, wbdb_sumj));
            bdenom[4] = bdenom[4] + wada_sumij * wbdb_sumij;
            bnumer[1] = bnumer[1] + Matrix.total(Matrix.elementMultiply(wadasa, wbdbsb));
            bnumer[2] = bnumer[2] + Matrix.total(Matrix.elementMultiply(wadasa_sumi, wbdbsb_sumi));
            bnumer[3] = bnumer[3] + Matrix.total(Matrix.elementMultiply(wadasa_sumj, wbdbsb_sumj));
            bnumer[4] = bnumer[4] + wadasa_sumij * wbdbsb_sumij;
            readerBdenom[ir][1] = Matrix.total(Matrix.elementMultiply(wada, wbdb));
            readerBdenom[ir][2] = Matrix.total(Matrix.elementMultiply(wada_sumi, wbdb_sumi));
            readerBdenom[ir][3] = Matrix.total(Matrix.elementMultiply(wada_sumj, wbdb_sumj));
            readerBdenom[ir][4] = wada_sumij * wbdb_sumij;
            readerBnumer[ir][1] = Matrix.total(Matrix.elementMultiply(wadasa, wbdbsb));
            readerBnumer[ir][2] = Matrix.total(Matrix.elementMultiply(wadasa_sumi, wbdbsb_sumi));
            readerBnumer[ir][3] = Matrix.total(Matrix.elementMultiply(wadasa_sumj, wbdbsb_sumj));
            readerBnumer[ir][4] = wadasa_sumij * wbdbsb_sumij;
            wadaSumr = Matrix.add(wadaSumr, wada);
            wbdbSumr = Matrix.add(wbdbSumr, wbdb);
            wadasaSumr = Matrix.add(wadasaSumr, wadasa);
            wbdbsbSumr = Matrix.add(wbdbsbSumr, wbdbsb);
            wadaSumir = Matrix.add(wadaSumir, wada_sumi);
            wbdbSumir = Matrix.add(wbdbSumir, wbdb_sumi);
            wadasaSumir = Matrix.add(wadasaSumir, wadasa_sumi);
            wbdbsbSumir = Matrix.add(wbdbsbSumir, wbdbsb_sumi);
            wadaSumjr = Matrix.add(wadaSumjr, wada_sumj);
            wbdbSumjr = Matrix.add(wbdbSumjr, wbdb_sumj);
            wadasaSumjr = Matrix.add(wadasaSumjr, wadasa_sumj);
            wbdbsbSumjr = Matrix.add(wbdbsbSumjr, wbdbsb_sumj);
            wadaSumijr += wada_sumij;
            wbdbSumijr += wbdb_sumij;
            wadasaSumijr += wadasa_sumij;
            wbdbsbSumijr += wbdbsb_sumij;
            if (totalda > 0) {
                totalwada += wa * (double)totalda;
                readerTotalwada[ir] = wa * (double)totalda;
                this.AUCs[ir][0] = Matrix.total(wadasa) / (double)totalda;
                aucA += (double)totalda * this.AUCs[ir][0];
            }
            if (totaldb > 0) {
                totalwbdb += wb * (double)totaldb;
                readerTotalwbdb[ir] = wb * (double)totaldb;
                this.AUCs[ir][1] = Matrix.total(wbdbsb) / (double)totaldb;
                aucB += (double)totaldb * this.AUCs[ir][1];
            }
            if (totalda > 0 && totaldb > 0) {
                this.AUCs[ir][2] = this.AUCs[ir][0] - this.AUCs[ir][1];
            }
            int irCov = 0;
            while ((long)irCov < this.Nreader) {
                int[][] designB1Cov;
                int[][] designB0Cov = Matrix.extractFirstDimension(d0, irCov, 1);
                int[][] dbCov = Matrix.multiply(designB0Cov, Matrix.matrixTranspose(designB1Cov = Matrix.extractFirstDimension(d1, irCov, 1)));
                int totaldbCov = Matrix.total(dbCov);
                if (totaldbCov > 0) {
                    totalwbdbCov += wb * (double)totaldbCov;
                    readerTotalwbdbCov[ir][irCov] = wb * (double)totaldbCov;
                }
                double wbCov = w[irCov][1];
                double[][] t0B_irCov = Matrix.extractFirstDimension(t0, irCov, 1);
                double[][] t1B_irCov = Matrix.extractFirstDimension(t1, irCov, 1);
                double[][] sb0Cov = Matrix.multiply(t0B_irCov, Matrix.matrixTranspose(ones_vect1));
                double[][] sb1Cov = Matrix.multiply(ones_vect0, Matrix.matrixTranspose(t1B_irCov));
                double[][] sbCov = Matrix.subtract(sb1Cov, sb0Cov);
                int i5 = 0;
                while ((long)i5 < this.Nnormal) {
                    int j = 0;
                    while ((long)j < this.Ndisease) {
                        if (sbCov[i5][j] < 0.0) {
                            sbCov[i5][j] = 0.0;
                        } else if (sbCov[i5][j] == 0.0) {
                            sbCov[i5][j] = 0.5;
                        } else if (sbCov[i5][j] > 0.0) {
                            sbCov[i5][j] = 1.0;
                        }
                        ++j;
                    }
                    ++i5;
                }
                double[][] wbdbCov = Matrix.linearTrans(dbCov, wbCov, 0.0);
                double[][] wbdbsbCov = Matrix.elementMultiply(wbdbCov, sbCov);
                double[] wada_sumiCov = Matrix.colSum(wada);
                double[] wbdb_sumiCov = Matrix.colSum(wbdbCov);
                double[] wadasa_sumiCov = Matrix.colSum(wadasa);
                double[] wbdbsb_sumiCov = Matrix.colSum(wbdbsbCov);
                double[] wada_sumjCov = Matrix.rowSum(wada);
                double[] wbdb_sumjCov = Matrix.rowSum(wbdbCov);
                double[] wadasa_sumjCov = Matrix.rowSum(wadasa);
                double[] wbdbsb_sumjCov = Matrix.rowSum(wbdbsbCov);
                double wada_sumijCov = Matrix.total(wada);
                double wbdb_sumijCov = Matrix.total(wbdbCov);
                double wadasa_sumijCov = Matrix.total(wadasa);
                double wbdbsb_sumijCov = Matrix.total(wbdbsbCov);
                readerBdenomCov[ir][irCov][1] = Matrix.total(Matrix.elementMultiply(wada, wbdbCov));
                readerBdenomCov[ir][irCov][2] = Matrix.total(Matrix.elementMultiply(wada_sumiCov, wbdb_sumiCov));
                readerBdenomCov[ir][irCov][3] = Matrix.total(Matrix.elementMultiply(wada_sumjCov, wbdb_sumjCov));
                readerBdenomCov[ir][irCov][4] = wada_sumijCov * wbdb_sumijCov;
                readerBnumerCov[ir][irCov][1] = Matrix.total(Matrix.elementMultiply(wadasa, wbdbsbCov));
                readerBnumerCov[ir][irCov][2] = Matrix.total(Matrix.elementMultiply(wadasa_sumiCov, wbdbsb_sumiCov));
                readerBnumerCov[ir][irCov][3] = Matrix.total(Matrix.elementMultiply(wadasa_sumjCov, wbdbsb_sumjCov));
                readerBnumerCov[ir][irCov][4] = wadasa_sumijCov * wbdbsb_sumijCov;
                ++irCov;
            }
            ++ir;
        }
        bdenom[5] = Matrix.total(Matrix.elementMultiply(wadaSumr, wbdbSumr));
        bdenom[6] = Matrix.total(Matrix.elementMultiply(wadaSumir, wbdbSumir));
        bdenom[7] = Matrix.total(Matrix.elementMultiply(wadaSumjr, wbdbSumjr));
        bdenom[8] = wadaSumijr * wbdbSumijr;
        bnumer[5] = Matrix.total(Matrix.elementMultiply(wadasaSumr, wbdbsbSumr));
        bnumer[6] = Matrix.total(Matrix.elementMultiply(wadasaSumir, wbdbsbSumir));
        bnumer[7] = Matrix.total(Matrix.elementMultiply(wadasaSumjr, wbdbsbSumjr));
        bnumer[8] = wadasaSumijr * wbdbsbSumijr;
        double[][] bias2unbias = new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, -1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, -1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 1.0, -1.0, -1.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, -1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, -1.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0}, {0.0, 1.0, 0.0, -1.0, 0.0, -1.0, 0.0, 1.0, 0.0}, {0.0, -1.0, 1.0, 1.0, -1.0, 1.0, -1.0, -1.0, 1.0}};
        double[] denom = Matrix.multiply((double[][])bias2unbias, bdenom);
        double[] numer = Matrix.multiply((double[][])bias2unbias, bnumer);
        momentsBiased = bnumer;
        int i6 = 0;
        while (i6 < momentsBiased.length) {
            if (bdenom[i6] > Matrix.min(w) / 2.0) {
                momentsBiased[i6] = momentsBiased[i6] / bdenom[i6];
            }
            ++i6;
        }
        moments = numer;
        i6 = 0;
        while (i6 < moments.length) {
            if (denom[i6] > Matrix.min(w) / 2.0) {
                moments[i6] = moments[i6] / denom[i6];
            }
            ++i6;
        }
        double[][] readerDenom = new double[(int)this.Nreader][5];
        double[][] readerNumer = new double[(int)this.Nreader][5];
        double[][][] readerDenomCov = new double[(int)this.Nreader][(int)this.Nreader][5];
        double[][][] readerNumerCov = new double[(int)this.Nreader][(int)this.Nreader][5];
        double[][] readerBias2unbias = new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, -1.0, 1.0, 0.0, 0.0}, {0.0, -1.0, 0.0, 1.0, 0.0}, {0.0, 1.0, -1.0, -1.0, 1.0}};
        int ir2 = 0;
        while ((long)ir2 < this.Nreader) {
            readerDenom[ir2] = Matrix.multiply((double[][])readerBias2unbias, readerBdenom[ir2]);
            readerNumer[ir2] = Matrix.multiply((double[][])readerBias2unbias, readerBnumer[ir2]);
            readerMomentsBiased = readerBnumer;
            int i7 = 0;
            while (i7 < readerMomentsBiased[0].length) {
                if (readerBdenom[ir2][i7] > Matrix.min(w) / 2.0) {
                    readerMomentsBiased[ir2][i7] = readerMomentsBiased[ir2][i7] / readerBdenom[ir2][i7];
                }
                ++i7;
            }
            readerMoments = readerNumer;
            i7 = 0;
            while (i7 < readerMoments[0].length) {
                if (readerDenom[ir2][i7] > Matrix.min(w) / 2.0) {
                    readerMoments[ir2][i7] = readerMoments[ir2][i7] / readerDenom[ir2][i7];
                }
                ++i7;
            }
            readerCoefficients[ir2] = Matrix.linearTrans(readerDenom[ir2], 1.0 / (readerTotalwada[ir2] * readerTotalwbdb[ir2]), 0.0);
            readerCoefficients[ir2][4] = readerCoefficients[ir2][4] - 1.0;
            int irCov = 0;
            while ((long)irCov < this.Nreader) {
                readerDenomCov[ir2][irCov] = Matrix.multiply((double[][])readerBias2unbias, readerBdenomCov[ir2][irCov]);
                readerNumerCov[ir2][irCov] = Matrix.multiply((double[][])readerBias2unbias, readerBnumerCov[ir2][irCov]);
                readerMomentsBiasedCov = readerBnumerCov;
                int i8 = 0;
                while (i8 < readerMomentsBiasedCov[0][0].length) {
                    if (readerBdenomCov[ir2][irCov][i8] > Matrix.min(w) / 2.0) {
                        readerMomentsBiasedCov[ir2][irCov][i8] = readerMomentsBiasedCov[ir2][irCov][i8] / readerBdenomCov[ir2][irCov][i8];
                    }
                    ++i8;
                }
                readerMomentsCov = readerNumerCov;
                i8 = 0;
                while (i8 < readerMomentsCov[0][0].length) {
                    if (readerDenomCov[ir2][irCov][i8] > Matrix.min(w) / 2.0) {
                        readerMomentsCov[ir2][irCov][i8] = readerMomentsCov[ir2][irCov][i8] / readerDenomCov[ir2][irCov][i8];
                    }
                    ++i8;
                }
                readerCoefficientsCov[ir2][irCov] = Matrix.linearTrans(readerDenomCov[ir2][irCov], 1.0 / (readerTotalwada[ir2] * readerTotalwbdbCov[ir2][irCov]), 0.0);
                readerCoefficientsCov[ir2][irCov][4] = readerCoefficientsCov[ir2][irCov][4] - 1.0;
                ++irCov;
            }
            ++ir2;
        }
        coefficients = Matrix.linearTrans(denom, 1.0 / (totalwada * totalwbdb), 0.0);
        coefficients[8] = coefficients[8] - 1.0;
        switch (flagModality) {
            case "AA": {
                if (Double.isInfinite(1.0 / totalwada)) {
                    this.AUCsReaderAvg[0] = -1.0;
                    return;
                }
                this.AUCsReaderAvg[0] = aucA / totalwada;
                this.momentsAA = moments;
                this.momentsBiasedAA = momentsBiased;
                this.readerMomentsAA = readerMoments;
                this.readerMomentsBiasedAA = readerMomentsBiased;
                this.coefficientsAA = coefficients;
                this.readerCoefficientsAA = readerCoefficients;
                this.readerMomentsAACov = readerMomentsCov;
                this.readerMomentsBiasedAACov = readerMomentsBiasedCov;
                this.readerCoefficientsAACov = readerCoefficientsCov;
                break;
            }
            case "BB": {
                if (Double.isInfinite(1.0 / totalwbdb)) {
                    this.AUCsReaderAvg[1] = -1.0;
                    return;
                }
                this.AUCsReaderAvg[1] = aucB / totalwbdb;
                this.momentsBB = moments;
                this.momentsBiasedBB = momentsBiased;
                this.readerMomentsBB = readerMoments;
                this.readerMomentsBiasedBB = readerMomentsBiased;
                this.coefficientsBB = coefficients;
                this.readerCoefficientsBB = readerCoefficients;
                this.readerMomentsBBCov = readerMomentsCov;
                this.readerMomentsBiasedBBCov = readerMomentsBiasedCov;
                this.readerCoefficientsBBCov = readerCoefficientsCov;
                break;
            }
            case "AB": {
                if (Double.isInfinite(1.0 / totalwada)) {
                    this.AUCsReaderAvg[0] = -1.0;
                    return;
                }
                if (Double.isInfinite(1.0 / totalwbdb)) {
                    this.AUCsReaderAvg[1] = -1.0;
                    return;
                }
                this.AUCsReaderAvg[0] = aucA / totalwada;
                this.AUCsReaderAvg[1] = aucB / totalwbdb;
                this.AUCsReaderAvg[2] = this.AUCsReaderAvg[0] - this.AUCsReaderAvg[1];
                this.momentsAB = moments;
                this.momentsBiasedAB = momentsBiased;
                this.readerMomentsAB = readerMoments;
                this.readerMomentsBiasedAB = readerMomentsBiased;
                this.coefficientsAB = coefficients;
                this.readerCoefficientsAB = readerCoefficients;
                this.readerMomentsABCov = readerMomentsCov;
                this.readerMomentsBiasedABCov = readerMomentsBiasedCov;
                this.readerCoefficientsABCov = readerCoefficientsCov;
            }
        }
    }

    public void makeTMatrices() {
        String modA = this.DBRecordStat.modalityA;
        String modB = this.DBRecordStat.modalityB;
        this.t0_modAB = new double[(int)this.Nnormal][(int)this.Nreader][2];
        this.t1_modAB = new double[(int)this.Ndisease][(int)this.Nreader][2];
        this.t0_modAA = new double[(int)this.Nnormal][(int)this.Nreader][2];
        this.t0_modBB = new double[(int)this.Nnormal][(int)this.Nreader][2];
        this.t1_modAA = new double[(int)this.Ndisease][(int)this.Nreader][2];
        this.t1_modBB = new double[(int)this.Ndisease][(int)this.Nreader][2];
        this.d0_modAA = new int[(int)this.Nnormal][(int)this.Nreader][2];
        this.d1_modAA = new int[(int)this.Ndisease][(int)this.Nreader][2];
        this.d0_modBB = new int[(int)this.Nnormal][(int)this.Nreader][2];
        this.d1_modBB = new int[(int)this.Ndisease][(int)this.Nreader][2];
        this.d0_modAB = new int[(int)this.Nnormal][(int)this.Nreader][2];
        this.d1_modAB = new int[(int)this.Ndisease][(int)this.Nreader][2];
        this.N0perReader = new int[(int)this.Nreader][3];
        this.N1perReader = new int[(int)this.Nreader][3];
        this.totalscoredA = 0;
        this.totalscoredB = 0;
        this.totalscoredAB = 0;
        int m = 0;
        int n = 0;
        int k = 0;
        for (String r : this.InputFileStat.keyedData.keySet()) {
            m = 0;
            n = 0;
            for (String c : this.InputFileStat.keyedData.get(r).keySet()) {
                int PresentModB;
                double ScoreModB;
                int PresentModA;
                double ScoreModA;
                if (this.InputFileStat.keyedData.get(r).containsKey(c)) {
                    if (this.InputFileStat.keyedData.get(r).get(c).containsKey(modA)) {
                        ScoreModA = this.InputFileStat.keyedData.get(r).get(c).get(modA);
                        PresentModA = 1;
                    } else {
                        ScoreModA = -1000000.0;
                        PresentModA = 0;
                        this.fullyCrossedA = false;
                    }
                    if (this.InputFileStat.keyedData.get(r).get(c).containsKey(modB)) {
                        ScoreModB = this.InputFileStat.keyedData.get(r).get(c).get(modB);
                        PresentModB = 1;
                    } else {
                        ScoreModB = -1000000.0;
                        PresentModB = 0;
                        this.fullyCrossedB = false;
                    }
                } else {
                    ScoreModA = -1000000.0;
                    ScoreModB = -1000000.0;
                    PresentModA = 0;
                    PresentModB = 0;
                    this.fullyCrossedAB = false;
                }
                if (this.InputFileStat.truthVals.get(c) == 0) {
                    this.t0_modAB[m][k][0] = ScoreModA;
                    this.t0_modAB[m][k][1] = ScoreModB;
                    this.t0_modAA[m][k][0] = ScoreModA;
                    this.t0_modAA[m][k][1] = ScoreModA;
                    this.t0_modBB[m][k][0] = ScoreModB;
                    this.t0_modBB[m][k][1] = ScoreModB;
                    this.d0_modAB[m][k][0] = PresentModA;
                    this.d0_modAB[m][k][1] = PresentModB;
                    this.d0_modAA[m][k][0] = PresentModA;
                    this.d0_modAA[m][k][1] = PresentModA;
                    this.d0_modBB[m][k][0] = PresentModB;
                    this.d0_modBB[m][k][1] = PresentModB;
                    this.N0perReader[k][0] = this.N0perReader[k][0] + PresentModA;
                    this.N0perReader[k][1] = this.N0perReader[k][1] + PresentModB;
                    this.N0perReader[k][2] = this.N0perReader[k][2] + Math.min(PresentModA, PresentModB);
                    this.totalscoredA += PresentModA;
                    this.totalscoredB += PresentModB;
                    this.totalscoredAB += PresentModA * PresentModB;
                    ++m;
                    continue;
                }
                this.t1_modAB[n][k][0] = ScoreModA;
                this.t1_modAB[n][k][1] = ScoreModB;
                this.t1_modAA[n][k][0] = ScoreModA;
                this.t1_modAA[n][k][1] = ScoreModA;
                this.t1_modBB[n][k][0] = ScoreModB;
                this.t1_modBB[n][k][1] = ScoreModB;
                this.d1_modAB[n][k][0] = PresentModA;
                this.d1_modAB[n][k][1] = PresentModB;
                this.d1_modAA[n][k][0] = PresentModA;
                this.d1_modAA[n][k][1] = PresentModA;
                this.d1_modBB[n][k][0] = PresentModB;
                this.d1_modBB[n][k][1] = PresentModB;
                this.N1perReader[k][0] = this.N1perReader[k][0] + PresentModA;
                this.N1perReader[k][1] = this.N1perReader[k][1] + PresentModB;
                this.N1perReader[k][2] = this.N1perReader[k][2] + Math.min(PresentModA, PresentModB);
                this.totalscoredA += PresentModA;
                this.totalscoredB += PresentModB;
                this.totalscoredAB += PresentModA * PresentModB;
                ++n;
            }
            ++k;
        }
    }

    public void makeDMatrices() {
        int NdiseasePerModality;
        int NnormalPerModality;
        int NreaderPerModality;
        this.t0_modAB = new double[(int)this.Nnormal][(int)this.Nreader][2];
        this.t1_modAB = new double[(int)this.Ndisease][(int)this.Nreader][2];
        this.t0_modAA = new double[(int)this.Nnormal][(int)this.Nreader][2];
        this.t0_modBB = new double[(int)this.Nnormal][(int)this.Nreader][2];
        this.t1_modAA = new double[(int)this.Ndisease][(int)this.Nreader][2];
        this.t1_modBB = new double[(int)this.Ndisease][(int)this.Nreader][2];
        this.d0_modAA = new int[(int)this.Nnormal][(int)this.Nreader][2];
        this.d0_modBB = new int[(int)this.Nnormal][(int)this.Nreader][2];
        this.d0_modAB = new int[(int)this.Nnormal][(int)this.Nreader][2];
        this.d1_modAA = new int[(int)this.Ndisease][(int)this.Nreader][2];
        this.d1_modBB = new int[(int)this.Ndisease][(int)this.Nreader][2];
        this.d1_modAB = new int[(int)this.Ndisease][(int)this.Nreader][2];
        this.N0perReader = new int[1][3];
        this.N1perReader = new int[1][3];
        if (this.SizePanel1.pairedReadersFlag == 1) {
            NreaderPerModality = (int)this.Nreader;
        } else {
            NreaderPerModality = (int)(this.Nreader / 2L);
            this.fullyCrossedA = false;
            this.fullyCrossedB = false;
            this.fullyCrossedAB = false;
        }
        if (this.SizePanel1.pairedNormalsFlag == 1) {
            NnormalPerModality = (int)this.Nnormal;
        } else {
            NnormalPerModality = (int)(this.Nnormal / 2L);
            this.fullyCrossedA = false;
            this.fullyCrossedB = false;
            this.fullyCrossedAB = false;
        }
        if (this.SizePanel1.pairedDiseasedFlag == 1) {
            NdiseasePerModality = (int)this.Ndisease;
        } else {
            NdiseasePerModality = (int)(this.Ndisease / 2L);
            this.fullyCrossedA = false;
            this.fullyCrossedB = false;
            this.fullyCrossedAB = false;
        }
        if (this.SizePanel1.numSplitPlots > 1) {
            this.fullyCrossedA = false;
            this.fullyCrossedB = false;
            this.fullyCrossedAB = false;
        }
        int NreaderPerGroup = NreaderPerModality / this.SizePanel1.numSplitPlots;
        int NnormalPerGroup = NnormalPerModality / this.SizePanel1.numSplitPlots;
        int NdiseasePerGroup = NdiseasePerModality / this.SizePanel1.numSplitPlots;
        this.N0perReader[0][0] = NnormalPerGroup;
        this.N0perReader[0][1] = NnormalPerGroup;
        this.N0perReader[0][2] = this.SizePanel1.pairedNormalsFlag == 1 ? NnormalPerGroup : 0;
        this.N1perReader[0][0] = NdiseasePerGroup;
        this.N1perReader[0][1] = NdiseasePerGroup;
        this.N1perReader[0][2] = this.SizePanel1.pairedDiseasedFlag == 1 ? NdiseasePerGroup : 0;
        int s = 0;
        while (s < this.SizePanel1.numSplitPlots) {
            int i = 0;
            while (i < NreaderPerGroup) {
                int caseID_modB;
                int caseID_modA;
                int readerID_modA = i + NreaderPerGroup * s;
                int readerID_modB = this.SizePanel1.pairedReadersFlag == 1 ? readerID_modA : readerID_modA + NreaderPerModality;
                int j = 0;
                while (j < NnormalPerGroup) {
                    caseID_modA = j + NnormalPerGroup * s;
                    caseID_modB = this.SizePanel1.pairedNormalsFlag == 1 ? caseID_modA : caseID_modA + NnormalPerModality;
                    this.d0_modAA[caseID_modA][readerID_modA][0] = 1;
                    this.d0_modAA[caseID_modA][readerID_modA][1] = 1;
                    this.d0_modBB[caseID_modB][readerID_modB][0] = 1;
                    this.d0_modBB[caseID_modB][readerID_modB][1] = 1;
                    this.d0_modAB[caseID_modA][readerID_modA][0] = 1;
                    this.d0_modAB[caseID_modB][readerID_modB][1] = 1;
                    ++j;
                }
                j = 0;
                while (j < NdiseasePerGroup) {
                    caseID_modA = j + NdiseasePerGroup * s;
                    caseID_modB = this.SizePanel1.pairedDiseasedFlag == 1 ? caseID_modA : caseID_modA + NdiseasePerModality;
                    this.d1_modAA[caseID_modA][readerID_modA][0] = 1;
                    this.d1_modAA[caseID_modA][readerID_modA][1] = 1;
                    this.d1_modBB[caseID_modB][readerID_modB][0] = 1;
                    this.d1_modBB[caseID_modB][readerID_modB][1] = 1;
                    this.d1_modAB[caseID_modA][readerID_modA][0] = 1;
                    this.d1_modAB[caseID_modB][readerID_modB][1] = 1;
                    ++j;
                }
                ++i;
            }
            ++s;
        }
    }
}

