% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAnnual(generic).R
\docType{methods}
\name{getAnnual}
\alias{getAnnual}
\alias{getAnnual,data.frame-method}
\alias{getAnnual,list-method}
\title{Get annual rainfall of different rainfall time series}
\usage{
getAnnual(data, output = "series", minRecords = 355, ...)

\S4method{getAnnual}{data.frame}(data, output = "series",
  minRecords = 355, ...)

\S4method{getAnnual}{list}(data, output = "series", minRecords = 355,
  ...)
}
\arguments{
\item{data}{A list containing different time series of different rainfall gauges. Or a dataframe with first column Date and the rest columns the value of different
gauging stations. Usually an output of \code{list2Dataframe}.}

\item{output}{A string showing the output output.}

\item{minRecords}{A number showing the minimum accept record number, e.g. for a normal 
year(365 days), if \code{minRecords = 360}, it means if a year has less than 360 records
of a year, it will be ignored in the mean annual value calculation. Only valid 
when \code{output = "mean"}, default is 355.}

\item{...}{\code{title, x, y} showing the title and x and y axis of the plot. e.g. \code{title = 'aaa'}}
}
\value{
The annual rainfall and the number of missing data of each year and each rainfall gauge, which 
will also be plotted. If output "mean" is seleted, the mean annual rainfall will be returned.
}
\description{
Get annual rainfall of different raninfall time series.
}
\details{
It is a generic function, if in your case you need to debug, please see \code{?debug()} 
for how to debug S4 method.
}
\examples{
#datalist is provided by the package as a test.
data(testdl)
a <- getAnnual(testdl)
#set minRecords to control the calculation of annual rainfall.
b <- getAnnual(testdl, output = 'mean', minRecords = 350)
c <- getAnnual(testdl, output = 'mean', minRecords = 365)

a1 <- extractPeriod(testdl, comm = TRUE)
a2 <- list2Dataframe(a1)
getAnnual(a2)

a3 <- fillGap(a2)
getAnnual(a3)


# More examples can be found in the user manual on https://yuanchao-xu.github.io/hyfo/

}
\references{
\itemize{
\item H. Wickham. ggplot2: elegant graphics for data analysis. Springer New York, 2009.
\item Hadley Wickham (2007). Reshaping Data with the reshape Package. Journal of Statistical Software,
21(12), 1-20. URL http://www.jstatsoft.org/v21/i12/.
\item R Core Team (2015). R: A language and environment for statistical computing. R Foundation for
Statistical Computing, Vienna, Austria. URL https://www.R-project.org/.
}
}
