% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ff_read_dgi.R
\name{read_dgi}
\alias{read_dgi}
\title{Reads data from Departamento General de Irrigación - Hydrological Division
(DGI - Mendoza - Argentina)}
\usage{
read_dgi(path, by = "day", out_name = NULL, sheet = NULL, get_sheet = FALSE)
}
\arguments{
\item{path}{path to the xlsx file.}

\item{by}{string with the time step of the series (e.g.: \code{'month', 'day', '6 hour',
'3 hour', '1 hour', '15 min' }). By default this argument is set to \code{'day'}.
 If you set it as \code{'none'}, the function will ignore automatic gap filling.}

\item{out_name}{optional. String vector with user defined variable(s) column(s) name(s).}

\item{sheet}{optional. Sheet to read. Either a string (the name of a sheet), or an integer
(the position of the sheet). If neither argument specifies the sheet, defaults to the first sheet.}

\item{get_sheet}{logical indicating whether you want to print available sheet names (\code{TRUE})
in the file or not.}
}
\value{
A data frame with the data inside the xlsx file. Gaps between dates are filled
 with \code{NA_real_} and duplicated rows are eliminated automatically.
}
\description{
Reads excel files provided by the DGI (Hydrological Division).
}
\examples{

# set path to file
path_file <- system.file('extdata', 'dgi_toscas.xlsx',
             package = 'hydrotoolbox')

# because dgi files has multiple sheets we take a look
# on them
read_dgi(path = path_file, get_sheet = TRUE)

# read swe with default column names
head( read_dgi(path = path_file, sheet = 'swe') )

# assign name
head( read_dgi(path = path_file, sheet = 'swe', out_name = 'swe(mm)') )

# now read relative humidity
head( read_dgi(path = path_file, sheet = 'hr', out_name = 'rh(\%)') )


}
