% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/11_hm_build_generic.R
\name{hm_build_generic}
\alias{hm_build_generic}
\alias{hm_build_generic,hydromet_station-method}
\title{Load native data files automatically}
\usage{
hm_build_generic(
  obj,
  path,
  file_name,
  slot_name,
  by = "none",
  out_name = NULL,
  sheet = NULL,
  FUN,
  ...
)

\S4method{hm_build_generic}{hydromet_station}(
  obj,
  path,
  file_name,
  slot_name,
  by = "none",
  out_name = NULL,
  sheet = NULL,
  FUN,
  ...
)
}
\arguments{
\item{obj}{a valid \code{hydromet_station} class object.}

\item{path}{string vector with the path(s) to the \code{file_name} argument.
If you set a single string it will be recycled for all the files.}

\item{file_name}{string vector with the native file(s) name(s).}

\item{slot_name}{string vector with the slot(s) where to set the file(s) or sheet(s).}

\item{by}{string vector with the time step of the series (e.g.: 'month',
day', '6 hour', '3 hour', '1 hour', '15 min' ). If you set it as \code{"none"},
the function will ignore automatic gap filling. If you set a single string,
it will be recycled for all the files.}

\item{out_name}{optional. A list containing string vectors with user
defined variable(s) column(s) name(s). The list length should be
equal to the \code{slot_name} length.}

\item{sheet}{Sheet to read (only excel files). Either a string vector
(the name of a sheet) or an integer vector (the position of the sheet).
This argument just make sense for excel files.}

\item{FUN}{function name for reading the data (e.g.: \code{read_csv()}). The method
will always use the \code{path + file} as first argument(s) to \code{FUN}.}

\item{...}{\code{FUN} arguments to pass.}
}
\value{
A \code{hydromet_station} object with the required data loaded inside.
}
\description{
The method allows you to automatically load your native data
inside the \code{hydromet_station} slots.
}
\section{Functions}{
\itemize{
\item \code{hm_build_generic(hydromet_station)}: build method for hydromet station object

}}
\examples{
\dontrun{
# you can download the data from:
# https://gitlab.com/ezetoum27/hydrotoolbox/-/tree/master/my_data

# set the data path
my_path <- "./home/my_folder/my_data"

#///////////////////////////////
# Rectangular data
# txt, csv, csv2 and others.
# See readr package.
#///////////////////////////////

library(readr)
#* Case 1: single file - many numeric variables

hm_create() \%>\%
hm_build_generic(path = my_path,
                 file_name = "ianigla_cuevas.csv",
                 slot_name = c("tair", "rh", "patm",
                              "precip", "wspd", "wdir",
                              "kin", "hsnow", "tsoil"),
                 by = c("hour"),
                 FUN = read_csv,
                 col_select = !Est & !YJday & !hh.mm.ss & !bat.Volts
                ) \%>\%
 hm_show()

#* Case 2: multiple files (one per observation)
hm_create() \%>\%
 hm_build_generic(path = my_path,
                  file_name = c("h_relativa_cuevas.csv",
                                "p_atm_cuevas.csv",
                                "precip_total_cuevas.csv",
                                "temp_aire_cuevas.csv",
                                "vel_viento_cuevas.csv"),
                  slot_name = c("rh", "patm", "precip",
                                "tair", "wspd"),
                  by = c("hour", "45 min", "30 min", "1 hour", "15 min"),
                  FUN = read_csv  ) \%>\%
 hm_show()

#///////////////////////////////
# Excel files
# Recommended package => readxl
#///////////////////////////////

library(readxl)


#* Case 1: single file - one sheet - many numeric variables

hm_create() \%>\%
 hm_build_generic(path = my_path,
                  file_name = "mnemos_guido.xlsx",
                  slot_name = c("qd"),
                  by = c("day"),
                  FUN = read_excel,
                  sheet = 1L,
                  skip = 3,
                  out_name = list("q_m3/s")
 ) \%>\% hm_show()



#* Case 2: single file - multiple sheets (one per variable)

hm_create() \%>\%
 hm_build_generic(path = my_path,
                  file_name = "mnemos_guido.xlsx",
                  slot_name = c("qd", "evap", "tair",
                                "tmax", "tmin"),
                  by = c(q = "day", evap =  "day", tair = "6 hour",
                         tmax = "day", tmin = "day"),
                  FUN = read_excel,
                  sheet = c(1L:5L),
                  skip = 3,
                  out_name = list( c("q_m3/s", "flag"),
                                   c("evap_mm", "flag"),
                                   c("tair", "flag"),
                                   c("tmax", "flag"),
                                   c("tmin", "flag")
                  )
 ) \%>\%
 hm_show()

#* Case 3: multiple files - one sheet per file

hm_create() \%>\%
  hm_build_generic(path = my_path,
                   file_name = c("discharge_daily.xlsx",
                                 "air_teperature_subdaily.xlsx"),
                   slot_name = c("qd", "tair"),
                   by = c(q = "day", tair = "6 hour"),
                   FUN = read_excel,
                   sheet = c(1L, 1L),
                   skip = 3,
                   out_name = list( c("q_m3/s", "flag"),
                                    c("tair", "flag"))
  ) \%>\%
  hm_show()

}

}
