% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/11_hm_build.R
\name{hm_build}
\alias{hm_build}
\alias{hm_build,hydromet_station-method}
\title{Load native data files automatically}
\usage{
hm_build(
  obj,
  bureau,
  path,
  file_name,
  slot_name,
  by,
  out_name = NULL,
  sheet = NULL
)

\S4method{hm_build}{hydromet_station}(
  obj,
  bureau,
  path,
  file_name,
  slot_name,
  by,
  out_name = NULL,
  sheet = NULL
)
}
\arguments{
\item{obj}{a valid \code{hydromet_station} class object.}

\item{bureau}{string value containing \bold{one} of the available options:
'aic', 'cr2', 'dgi', 'ianigla', 'mnemos' or 'snih'.}

\item{path}{string vector with the path(s) to the \code{file_name} argument.
If you set a single string it will be recycled for all the files.}

\item{file_name}{string vector with the native file(s) name(s).}

\item{slot_name}{string vector with the slot(s) where to set the file(s) or sheet(s).}

\item{by}{string vector with the time step of the series (e.g.: 'month', 'day', '6 hour', '3 hour',
'1 hour', '15 min' ). If you set it as 'none', the function will ignore automatic gap filling.
If you set a single string it will be recycled for all the files.}

\item{out_name}{optional. String vector with user defined variable(s) column(s) name(s).}

\item{sheet}{optional. Sheet to read. Either a string vector (the name of a sheet), or an integer
vector (the position of the sheet). If neither argument specifies the sheet, defaults to the first
sheet. This argument just make sense for:
\itemize{
\item 'aic': you must provide a single name or integer indicating the met-station to read.
\item 'dgi': just keep it as \code{NULL}.
\item 'mnemos': just keep it as \code{NULL}.
}}
}
\value{
A \code{hydromet_station} object with the required data loaded inside.
}
\description{
The method allows you to automatically load your native data
inside the \code{hydromet_station} slots.
}
\section{Functions}{
\itemize{
\item \code{hm_build,hydromet_station-method}: build method for hydromet station object
}}

\examples{

# path to all example files
path <- system.file('extdata', package = 'hydrotoolbox')

# ianigla file
hm_create() \%>\%
  hm_build(bureau = 'ianigla', path = path,
           file_name = 'ianigla_cuevas.csv',
           slot_name = c('tair', 'rh', 'patm',
                         'precip', 'wspd', 'wdir',
                         'kin', 'hsnow', 'tsoil'),
           by = 'hour',
           out_name = c('tair(°C)', 'rh(\%)', 'patm(mbar)',
                        'p(mm)', 'wspd(km/hr)', 'wdir(°)',
                        'kin(kW/m2)', 'hsnow(cm)', 'tsoil(°C)' )
          ) \%>\%
          hm_show()

# cr2 file
hm_create() \%>\%
  hm_build(bureau = 'cr2', path = path,
           file_name = 'cr2_tmax_yeso_embalse.csv',
           slot_name = c('tmax'),
           by = 'day',
           out_name = c('tair(°C)' )
          )  \%>\%
          hm_show()

# dgi file
hm_create() \%>\%
  hm_build(bureau = 'dgi', path = path,
           file_name = 'dgi_toscas.xlsx',
           slot_name = c('swe', 'tmax',
           'tmin', 'tmean', 'rh', 'patm'),
           by = 'day' ) \%>\%
          hm_show()

# snih file
hm_create() \%>\%
  hm_build(bureau = 'snih', path = path,
           file_name = c('snih_hq_guido.xlsx',
           'snih_qd_guido.xlsx'),
           slot_name = c('hq', 'qd'),
           by = c('none', 'day') ) \%>\%
          hm_show()

# aic    => you have to request for this files to AIC.

# mnemos => the data are the same of snih but generated
#           with MNEMOSIII software.


}
